% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secondOrderMarkovModel.R
\name{secondOrderMarkovModel}
\alias{secondOrderMarkovModel}
\title{A class to train Second Order Markov Models#'}
\usage{
secondOrderMarkovModel(parameters.list = list())
}
\arguments{
\item{parameters.list}{a list containing the parameters. The possible ones are: 'considerAutoLoop' and 'threshold'. 'considerAutoLoop' is a boolean which indicates if the autoloops have to be admitted, while 'threshold' is the minimum value that a probability should have to do not be set to zero, in the transition matrix.}
}
\description{
This is an implementation of the Second Order Markov Model (SOMM) for Process Mining issues.
               This class provides a minimal set of methods to handle with the FOMM model:
               \itemize{
               \item \code{secondOrderMarkovModel( ) } is the costructor
               \item \code{loadDataset( ) } loads data taken from a dataLoader::getData() method, into a SOMM object
               \item \code{trainModel( ) } train a model using the previously loaded dataset
               \item \code{replay( ) } re-play a given event log on the internal SOMM model
               \item \code{play( ) } play the internal FOMM model a desired number of times, in order to simulate new event-logs. This methods can also, if desired, simulate event-logs which does not complies with the internal SOMM model.
               \item \code{getModel( ) } return the trained internal SOMM model
               }
             In order to better undestand the use of such methods, please visit: www.pminer.info
             
             The consturctor admit the following parameters:
parameters.list a list containing possible parameters to tune the model.
}
\examples{
\dontrun{

# create a Loader
obj.L<-dataLoader();   

# Load a .csv 
obj.L$load.csv(nomeFile = "../otherFiles/mammella.csv",
IDName = "CODICE_SANITARIO_ADT",
EVENTName = "DESC_REPARTO_RICOVERO",
dateColumnName = "DATA_RICOVERO")

# get the loaded data
dati <- obj.L$getData()

# build a Second Order Marvov Model with a threshold of 0.2
SOMM <- secondOrderMarkovModel( 
parameters.list = list("threshold"=0.002))

# load the data
SOMM$loadDataset(dataList = dati)

# train a model
SOMM$trainModel()

# generate 10 new processes (nb: if the 
# threshold is too low, it can fail...)
aaa <- SOMM$play(numberOfPlays = 10)

# get the transition matrix
TranMatrix <- SOMM$getModel(kindOfOutput = "MM.2.Matrix.perc")


}
}

