% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstOrderMarkovModel.R
\name{firstOrderMarkovModel}
\alias{firstOrderMarkovModel}
\title{firstOrderMarkovModel class}
\usage{
firstOrderMarkovModel(parameters.list = list())
}
\arguments{
\item{parameters.list}{a list containing possible parameters to tune the model. The admitted element of the input list are:
\itemize{
 \item \code{threshold } a number between 0 and 1 (default is 0). In the graph, arcs with a probability under the threshold will be removed;
 \item \code{considerAutoLoop } a boolean parameter (default is \code{TRUE}). If \code{FALSE} the arcs outcoming and incoming in the same node will be removed.
}}
}
\description{
This is an implementation of the First Order Markov Model (FOMM) for Process Mining issues.
               This class provides a minimal set of methods to handle with the FOMM model:
               \itemize{
               \item \code{firstOrderMarkovModel( ...) } is the costructor
               \item \code{loadDataset( ...) } loads data into a FOMM object
               \item \code{trainModel() } trains a FOMM model
               \item \code{getModel() } returns the model (XML or graphical way, via grViz script)
               \item \code{replay( ... )} submits a set of given sequences and returns the fitting (not yet implemented for this algorithm)
               \item \code{play( ... )} generates a wished number of sequences
               \item \code{plot() } plots the graph
               \item \code{distanceFrom( ... )} allows to calculate the distance between two different FOMM objects
               \item \code{plot.delta.graph( ... ) } plots a distance graph between two given FOMM objects
               }
             There are two ways to use this class: directly using the methods previously 
             listed or via wrapping functions (called PM.<method name>). In the examples section you will find an example of both.
}
\examples{
\dontrun{
# ----------------------------------------------- 
#  USING THE METHODS of the class
# ----------------------------------------------- 
obj.L<-dataLoader();   # create a Loader

# Load a .csv using "DES" and "ID" as column names to indicate events 
# and Patient's ID
obj.L$loader(nomeFile = "./otherFiles/test_02.csv",
IDName = "ID",EVENTName = "DES")

# now create an object firstOrderMarkovModel
obj.MM<-firstOrderMarkovModel();    

# load the data into MM model
obj.MM$loadDataset( obj.L$getData() );  

# train the model
obj.MM$trainModel();  

# plot the model 
obj.MM$plot();  

# -----------------------------------------------
##  USING THE WRAPPER Functions
# -----------------------------------------------
# Instantiate a 'firstOrderMarkovModel' model
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "./otherFiles/test_02.csv",
   IDName = "ID",EVENTName = "DES")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "firstOrderMarkovModel")

# Load the PM model
PM.loadDataset(PM.obj = obj.PM,dataList = LD.getData(loader.obj = obj.LD))

# train it
PM.trainModel(PM.obj = obj.PM)

# plot the model 
PM.plot(PM.obj = obj.PM)

}
}

