% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliertree.R
\name{print.outlieroutputs}
\alias{print.outlieroutputs}
\title{Print outliers in human-readable format}
\usage{
\method{print}{outlieroutputs}(x, outliers_print = 15L, min_decimals = 2L, only_these_rows = NULL, ...)
}
\arguments{
\item{x}{Outliers as returned by predict method on an object from `outlier.tree`.}

\item{outliers_print}{Maximum number of outliers to print.}

\item{min_decimals}{Minimum number of decimals to use when printing numeric values for the flagged
outliers. The number of decimals will be dynamically increased according to the relative magnitudes of the
values being reported. Ignored when passing `outliers_print=0` or `outliers_print=FALSE`.}

\item{only_these_rows}{Specific rows to print (either numbers if the row names in the original
data frame were null, or the row names they had if non-null). Pass `NULL` to print information
about potentially all rows}

\item{...}{Not used.}
}
\value{
The same input `x` that was passed (as `invisible`).
}
\description{
Pretty-prints outliers as output by the `predict` function from an Outlier Tree
model (as generated by function `outlier.tree`), or by `extract.training.outliers`.
Same as function `summary`.
}
\examples{
### Example re-printing results for selected rows
library(outliertree)
data("hypothyroid")

### Fit model
otree <- outlier.tree(hypothyroid,
  nthreads=1,
  outliers_print=0)
  
### Store predictions
pred <- predict(otree,
  hypothyroid,
  outliers_print=0,
  return_outliers=TRUE)
  
### Print stored predictions
### Row 531 is an outlier, but 532 is not
print(pred, only_these_rows = c(531, 532))
}
\seealso{
\link{outlier.tree} \link{predict.outliertree}
}
