% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lpdf}
\alias{lpdf}
\alias{Rcpp_lpdf-class}
\alias{Rcpp_lpdf}
\title{Log probability density function class}
\value{
no returns, this is a class which contains methods
}
\description{
This is a base class designed to handle the learning of 
the underlying coefficients, hyperparameters, and parameters associated with
a specific learning instance.  Polymorphism allows for the implied methods to 
be used across several similar classes.
}
\section{Fields}{

\describe{
\item{\code{lpdf$val}}{current value}

\item{\code{lpdf$para}}{current model parameters}

\item{\code{lpdf$coeff}}{current coefficients}

\item{\code{lpdf$compute_val}}{on calling \code{update}, compute value and store in 
\code{val}}

\item{\code{lpdf$grad}}{current gradient with respect to coefficients}

\item{\code{lpdf$gradhyp}}{current gradient with respect to covariance hyperparameters}

\item{\code{lpdf$gradpara}}{current gradient with respect to model parameters}

\item{\code{lpdf$compute_grad}}{on calling \code{update}, compute gradient with 
respect to coefficients and store in \code{grad}}

\item{\code{lpdf$compute_gradhyp}}{on calling \code{update}, compute gradient
with respect to covariance hyperparameters and store in \code{gradhyp}}

\item{\code{lpdf$compute_gradpara}}{on calling \code{update}, compute gradient
with respect to model parameters and store in \code{gradpara}}

\item{\code{lpdf$update(coeff)}}{update using new coefficients}

\item{\code{\link{lpdf$optcg}(tol,epoch)}}{do optimization with respect to coefficients 
via conjugate gradient}

\item{\code{\link{lpdf$optnewton}()}}{do optimization via matrix inversion, one Newton 
step}

\item{\code{lpdf$updateom()}}{update based on recent version of \code{\link{outermod}}}

\item{\code{lpdf$updatepara(para)}}{update using new model parameters}

\item{\code{lpdf$updateterms(terms)}}{update using new \code{terms}}

\item{\code{lpdf$hess()}}{returns the hessian with respect 
to coefficients}

\item{\code{lpdf$hessgradhyp()}}{returns gradient of \code{hess()} with respect to 
covariance hyperparameters}

\item{\code{lpdf$hessgradpara()}}{returns the gradient of \code{hess()} with respect to 
model parameters}

\item{\code{lpdf$diaghess()}}{returns the diagonal of the hessian with 
respect to coefficients}

\item{\code{lpdf$diaghessgradhyp()}}{returns the gradient of \code{diaghess()} with 
respect to  covariance hyperparameters}

\item{\code{lpdf$diaghessgradpara()}}{returns the gradient of \code{diaghess()} with 
respect to model parameters}

\item{\code{lpdf$paralpdf(para)}}{compute the log-prior on the parameters, useful for 
fitting}

\item{\code{lpdf$paralpdf_grad(para)}}{gradient of \code{paralpdf(para)}}
}}

\seealso{
container class: \code{\link{lpdfvec}}

derived classes: \code{\link{loglik_std}}, 
\code{\link{loglik_gauss}}, \code{\link{loglik_gda}}, 
\code{\link{logpr_gauss}}
}
