% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_registration.R
\name{dataset_registration}
\alias{dataset_registration}
\title{Returns the formatted registration data set}
\usage{
dataset_registration(
  module = c("All", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG"),
  presentation = c("2013B", "2014B", "2013J", "2014J", "All", "Summer", "Winter"),
  repeat_students = c("remove", "keep")
)
}
\arguments{
\item{module}{name of the module to be included, either \code{"All"}, \code{"AAA"}, \code{"BBB"}, \code{"CCC"}, \code{"DDD"}, \code{"EEE"}, \code{"FFF"} or \code{"GGG"}.}

\item{presentation}{name of the semester of the module to be included, either \code{"2013B"},
\code{"2014B"}, \code{"2013J"}, \code{"2014J"}, \code{"All"}, \code{"Summer"} or \code{"Winter"}.
\code{"B"} indicates a February start time whereas \code{"J"} indicates an October start time. \code{"All"} indicates
that all presentations of the module will be included in the returned data. Where possible,  \code{"Summer"} returns
both \code{"2013B"} and \code{"2014B"}, and \code{"Winter"} returns both \code{"2013J"} and \code{"2014J"}.}

\item{repeat_students}{indicator of whether students who had previous attempts at the module should be removed, either \code{"remove"} or \code{"keep"}.}
}
\value{
Returns one \code{tibble} (object of class \code{tbl_df}), called 'studentRegistration', based on the OULAD studentRegistration.csv file
and the specified inputs (module, presentation, and repeat_students).

The \code{tibble} consists of five columns (Kuzilek et al., 2017):

\itemize{
\item{id_student - the unique student identification number.}
\item{code_module - module identification code.}
\item{code_presentation - module presentation identification code.}
\item{date_registration - the day of student’s registration for the module presentation. Modules start on day 0.}
\item{date_unregistration - the day of student unregistration from the module presentation. This is NA if the student completed the module presentation.}
}
}
\description{
Load and formats the student registration data set from the OULAD for data analysis.
}
\examples{
dataset_registration(module = "BBB", presentation = "2013J", repeat_students = "remove")
}
\references{
Kuzilek, J., Hlosta, M., & Zdrahal, Z. (2017). Open university learning analytics data set. Scientific Data
volume 4 , (pp. 1–8). https://doi.org/10.1038/sdata.2017.171.
}
\seealso{
\code{\link[=combined_dataset]{combined_dataset()}}
}
