% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-checks.R
\name{hasOnlyDistinctValues}
\alias{hasOnlyDistinctValues}
\title{Check that an array of values does not include any duplicate}
\usage{
hasOnlyDistinctValues(values, na.rm = TRUE)
}
\arguments{
\item{values}{An array of values}

\item{na.rm}{Logical to decide if missing values should be removed from the
duplicate checking. Note that duplicate \code{NA} values are flagged if
\code{na.rm=FALSE}.}
}
\value{
Logical assessing if all values are unique
}
\description{
Check that an array of values does not include any duplicate
}
\examples{
hasOnlyDistinctValues(c("x", "y"))
hasOnlyDistinctValues(c("x", "y", "x"))
hasOnlyDistinctValues(c("x", NA, "y", NA), na.rm = FALSE)
hasOnlyDistinctValues(c("x", NA, "y", NA), na.rm = TRUE)
}
