/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;
import fr.ird.osmose.process.mortality.MortalityCause;

public class YieldOutput
extends AbstractOutput {
    public double[] yield;

    public YieldOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.yield = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int n = school.getSpeciesIndex();
            this.yield[n] = this.yield[n] + school.adb2biom(school.getNdead(MortalityCause.FISHING));
        }
    }

    @Override
    public void write(float time) {
        this.writeVariable(time, this.yield);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_yield_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "cumulative catch (tons per time step of saving). ex: if time step of saving is the year, then annual catches are saved";
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

