/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import fr.ird.osmose.Cell;
import fr.ird.osmose.IAggregation;
import fr.ird.osmose.School;
import fr.ird.osmose.process.AbstractProcess;
import fr.ird.osmose.process.mortality.AdditionalMortality;
import fr.ird.osmose.process.mortality.FishingMortality;
import fr.ird.osmose.process.mortality.MortalityCause;
import fr.ird.osmose.process.mortality.PredationMortality;
import fr.ird.osmose.util.XSRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class StochasticMortalityProcess
extends AbstractProcess {
    private static Random random;
    private int subdt;
    private AdditionalMortality additionalMortality;
    private FishingMortality fishingMortality;
    private PredationMortality predationMortality;

    public StochasticMortalityProcess(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        random = new XSRandom(System.nanoTime());
        this.additionalMortality = new AdditionalMortality(this.getRank());
        this.additionalMortality.init();
        this.fishingMortality = new FishingMortality(this.getRank());
        this.fishingMortality.init();
        this.predationMortality = new PredationMortality(this.getRank());
        this.predationMortality.init();
        if (!this.getConfiguration().isNull("mortality.subdt")) {
            this.subdt = this.getConfiguration().getInt("mortality.subdt");
        } else {
            this.subdt = 10;
            this.warning("Did not find parameter 'mortality.subdt' for stochastic mortality algorithm.");
        }
        this.info("Mortality subdt set to " + this.subdt);
    }

    @Override
    public void run() {
        this.fishingMortality.setMPA();
        for (Cell cell : this.getGrid().getCells()) {
            List<School> schools = this.getSchoolSet().getSchools(cell);
            if (cell.isLand() || schools.isEmpty()) continue;
            ArrayList<IAggregation> preys = new ArrayList<IAggregation>();
            preys.addAll(schools);
            for (int i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
                preys.add(this.getSimulation().getPlankton(i).getSwarm(cell));
            }
            for (School school : schools) {
                school.setAccessibility(this.predationMortality.getAccessibility(school, preys));
                school.setPredSuccessRate(0.0f);
                if (school.getAgeDt() != 0) continue;
                double D = this.additionalMortality.getRate(school);
                double nDead = school.getInstantaneousAbundance() * (1.0 - Math.exp(-D));
                school.incrementNdead(MortalityCause.ADDITIONAL, nDead);
                school.retainEgg();
            }
        }
        int iStepSimu = this.getSimulation().getIndexTimeSimu();
        for (int iLTL = 0; iLTL < this.getConfiguration().getNPlankton(); ++iLTL) {
            this.getSimulation().getPlankton(iLTL).updateSwarms(iStepSimu);
        }
        for (int idt = 0; idt < this.subdt; ++idt) {
            this.fishingMortality.assessFishableBiomass();
            for (Cell cell : this.getGrid().getCells()) {
                if (cell.isLand()) continue;
                this.computeMortality_stochastic(this.subdt, cell);
            }
        }
    }

    public void computeMortality_stochastic(int subdt, Cell cell) {
        List<School> schools = this.getSchoolSet().getSchools(cell);
        int ns = schools.size();
        if (ns == 0) {
            return;
        }
        ArrayList<IAggregation> preys = new ArrayList<IAggregation>();
        preys.addAll(schools);
        for (School prey : schools) {
            if (prey.getAgeDt() != 0) continue;
            prey.releaseEgg(subdt);
        }
        for (int i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
            preys.add(this.getSimulation().getPlankton(i).getSwarm(cell));
        }
        Integer[] seqPred = new Integer[ns];
        for (int i = 0; i < ns; ++i) {
            seqPred[i] = i;
        }
        Integer[] seqFish = Arrays.copyOf(seqPred, ns);
        Integer[] seqNat = Arrays.copyOf(seqPred, ns);
        Integer[] seqStarv = Arrays.copyOf(seqPred, ns);
        MortalityCause[] mortalityCauses = MortalityCause.values();
        FishingMortality.Type fishingType = this.fishingMortality.getType();
        StochasticMortalityProcess.shuffleArray(seqPred);
        StochasticMortalityProcess.shuffleArray(seqFish);
        StochasticMortalityProcess.shuffleArray(seqNat);
        StochasticMortalityProcess.shuffleArray(seqStarv);
        int nspec = this.getConfiguration().getNSpecies();
        boolean keepRecord = this.getSimulation().isPreyRecord();
        for (int i = 0; i < ns; ++i) {
            StochasticMortalityProcess.shuffleArray(mortalityCauses);
            block14: for (MortalityCause cause : mortalityCauses) {
                double nDead = 0.0;
                switch (cause) {
                    case PREDATION: {
                        School predator = schools.get(seqPred[i]);
                        double[] preyUpon = this.predationMortality.computePredation(predator, preys, predator.getAccessibility(), subdt);
                        for (int ipr = 0; ipr < preys.size(); ++ipr) {
                            if (!(preyUpon[ipr] > 0.0)) continue;
                            IAggregation prey = (IAggregation)preys.get(ipr);
                            nDead = prey.biom2abd(preyUpon[ipr]);
                            prey.incrementNdead(MortalityCause.PREDATION, nDead);
                            predator.preyedUpon(prey.getSpeciesIndex(), prey.getTrophicLevel(), prey.getAge(), prey.getLength(), preyUpon[ipr], keepRecord);
                        }
                        continue block14;
                    }
                    case STARVATION: {
                        School school = schools.get(seqStarv[i]);
                        double M = school.getStarvationRate() / (double)subdt;
                        nDead = school.getInstantaneousAbundance() * (1.0 - Math.exp(-M));
                        school.incrementNdead(MortalityCause.STARVATION, nDead);
                        continue block14;
                    }
                    case ADDITIONAL: {
                        School school = schools.get(seqNat[i]);
                        if (school.getAgeDt() <= 0) continue block14;
                        double D = this.additionalMortality.getRate(school) / (double)subdt;
                        nDead = school.getInstantaneousAbundance() * (1.0 - Math.exp(-D));
                        school.incrementNdead(MortalityCause.ADDITIONAL, nDead);
                        continue block14;
                    }
                    case FISHING: {
                        School school = schools.get(seqFish[i]);
                        switch (fishingType) {
                            case RATE: {
                                double F = this.fishingMortality.getRate(school) / (double)subdt;
                                nDead = school.getInstantaneousAbundance() * (1.0 - Math.exp(-F));
                                break;
                            }
                            case CATCHES: {
                                nDead = school.biom2abd(this.fishingMortality.getCatches(school) / (double)subdt);
                            }
                        }
                        school.incrementNdead(MortalityCause.FISHING, nDead);
                    }
                }
            }
        }
    }

    private static <T> void shuffleArray(T[] a) {
        for (int i = a.length; i > 1; --i) {
            T tmp = a[i - 1];
            int j = random.nextInt(i);
            a[i - 1] = a[j];
            a[j] = tmp;
        }
    }
}

