/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process;

import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.AbstractProcess;

public class GrowthProcess
extends AbstractProcess {
    private float[][] minDelta;
    private float[][] maxDelta;
    private float[][] deltaMeanLength;
    private float[] criticalPredSuccess;
    private float[] lmax;

    public GrowthProcess(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        int nSpecies = this.getConfiguration().getNSpecies();
        this.criticalPredSuccess = new float[nSpecies];
        this.minDelta = new float[nSpecies][];
        this.maxDelta = new float[nSpecies][];
        this.deltaMeanLength = new float[nSpecies][];
        this.lmax = new float[nSpecies];
        for (int i = 0; i < nSpecies; ++i) {
            this.criticalPredSuccess[i] = this.getConfiguration().getFloat("predation.efficiency.critical.sp" + i);
            Species species = this.getSpecies(i);
            int lifespan = species.getLifespanDt();
            this.minDelta[i] = new float[lifespan];
            this.maxDelta[i] = new float[lifespan];
            this.deltaMeanLength[i] = new float[lifespan];
            float meanAge1 = species.computeMeanLength(0);
            for (int age = 0; age < lifespan - 1; ++age) {
                float meanAge0 = meanAge1;
                meanAge1 = species.computeMeanLength(age + 1);
                this.deltaMeanLength[i][age] = meanAge1 - meanAge0;
                this.minDelta[i][age] = this.deltaMeanLength[i][age] - this.deltaMeanLength[i][age];
                this.maxDelta[i][age] = this.deltaMeanLength[i][age] + this.deltaMeanLength[i][age];
            }
            this.lmax[i] = !this.getConfiguration().isNull("species.lmax.sp" + i) ? this.getConfiguration().getFloat("species.lmax.sp" + i) : Float.POSITIVE_INFINITY;
        }
    }

    @Override
    public void run() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            Species species = school.getSpecies();
            int i = species.getIndex();
            int age = school.getAgeDt();
            if (age == 0 || school.isUnlocated()) {
                school.incrementLength(this.deltaMeanLength[i][age]);
                continue;
            }
            if (!(school.getLength() < this.lmax[i])) continue;
            this.growth(school, this.minDelta[i][age], this.maxDelta[i][age]);
        }
    }

    public void growth(School school, float minDelta, float maxDelta) {
        int iSpec = school.getSpeciesIndex();
        if (school.getPredSuccessRate() >= this.criticalPredSuccess[iSpec]) {
            float dlength = minDelta + (maxDelta - minDelta) * ((school.getPredSuccessRate() - this.criticalPredSuccess[iSpec]) / (1.0f - this.criticalPredSuccess[iSpec]));
            school.incrementLength(dlength);
        }
    }
}

