/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.ltl;

import fr.ird.osmose.ltl.AbstractLTLForcing;
import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class LTLForcingBFM
extends AbstractLTLForcing {
    private String[] planktonFileListNetcdf;
    private String zlevelName;
    private String bathyFile;
    private String bathyName;
    private String[] planktonNetcdfNames;
    private float[][][] depthOfLayer;
    private int[][][] indexOceanpoint;
    private int im;
    private int jm;
    private int km;
    private int timeDim;
    private int stride;

    public LTLForcingBFM(int rank) {
        super(rank);
    }

    @Override
    public void readParameters() {
        int i;
        this.planktonNetcdfNames = new String[this.getConfiguration().getNPlankton()];
        for (i = 0; i < this.getConfiguration().getNPlankton(); ++i) {
            this.planktonNetcdfNames[i] = this.getConfiguration().getString("ltl.netcdf.var.plankton.plk" + i);
        }
        this.planktonFileListNetcdf = new String[this.getConfiguration().findKeys("ltl.netcdf.file.t*").size()];
        for (i = 0; i < this.planktonFileListNetcdf.length; ++i) {
            this.planktonFileListNetcdf[i] = this.getConfiguration().getFile("ltl.netcdf.file.t" + i);
        }
        this.timeDim = this.getConfiguration().getInt("ltl.netcdf.dim.ntime");
        this.bathyFile = this.getConfiguration().getFile("grid.netcdf.file");
        this.zlevelName = this.getConfiguration().getString("ltl.netcdf.var.zlevel");
        this.bathyName = this.getConfiguration().getString("ltl.netcdf.var.bathy");
        this.stride = this.getConfiguration().getInt("grid.stride");
    }

    @Override
    public void initLTLGrid() {
        try {
            NetcdfFile nc = NetcdfFile.open(this.bathyFile, null);
            float[] zlevel = (float[])nc.findVariable(this.zlevelName).read().copyToNDJavaArray();
            this.km = nc.findDimension("zpos").getLength() - 1;
            this.jm = nc.findDimension("ypos").getLength();
            this.im = nc.findDimension("xpos").getLength();
            float[][] bathy = (float[][])nc.findVariable(this.bathyName).read().copyToNDJavaArray();
            nc.close();
            this.depthOfLayer = new float[this.km][this.jm][this.im];
            for (int z = 0; z < this.km; ++z) {
                for (int j = 0; j < this.jm; ++j) {
                    for (int i = 0; i < this.im; ++i) {
                        this.depthOfLayer[z][j][i] = bathy[j][i] * zlevel[z];
                    }
                }
            }
            this.icoordLTLGrid = new ArrayList[this.getGrid().get_ny()][this.getGrid().get_nx()];
            this.jcoordLTLGrid = new ArrayList[this.getGrid().get_ny()][this.getGrid().get_nx()];
            for (int j = 0; j < this.getGrid().get_ny(); ++j) {
                for (int i = 0; i < this.getGrid().get_nx(); ++i) {
                    for (int ii = 0; ii < this.stride; ++ii) {
                        for (int jj = 0; jj < this.stride; ++jj) {
                            if (null == this.icoordLTLGrid[j][i]) {
                                this.icoordLTLGrid[j][i] = new ArrayList();
                                this.jcoordLTLGrid[j][i] = new ArrayList();
                            }
                            this.jcoordLTLGrid[j][i].add(j * this.stride + jj);
                            this.icoordLTLGrid[j][i].add(i * this.stride + ii);
                        }
                    }
                }
            }
            this.indexMapping();
        }
        catch (IOException ex) {
            this.error("Error reading BFM grid from file " + this.bathyFile, ex);
        }
    }

    private int ijk2oceanpoint(int i, int j, int k) {
        return this.indexOceanpoint[k][j][i];
    }

    private void indexMapping() throws IOException {
        String gridFile = this.getConfiguration().getFile("grid.netcdf.file");
        String strMask = this.getConfiguration().getString("grid.var.mask");
        NetcdfFile nc = NetcdfFile.open(gridFile, null);
        float[][] mask = (float[][])nc.findVariable(strMask).read().copyToNDJavaArray();
        int cont = 0;
        this.indexOceanpoint = new int[this.km][this.jm][this.im];
        for (int k = 0; k < this.km; ++k) {
            for (int j = 0; j < this.jm; ++j) {
                for (int i = 0; i < this.im; ++i) {
                    this.indexOceanpoint[k][j][i] = mask[j][i] > 0.0f ? cont++ : -1;
                }
            }
        }
    }

    @Override
    double[][] getRawBiomass(int iPlankton, int iStepSimu) {
        String name = this.planktonFileListNetcdf[this.getIndexStepLTL(iStepSimu)];
        float[][][] data3d = new float[this.km][this.jm][this.im];
        try {
            NetcdfFile nc = NetcdfFile.open(name);
            int timestep = iStepSimu % this.timeDim;
            Variable ncvar = nc.findVariable(this.planktonNetcdfNames[iPlankton]);
            int[] shape = ncvar.getShape();
            float[] variable = (float[])ncvar.read(new int[]{timestep, 0}, new int[]{1, shape[1]}).reduce().copyToNDJavaArray();
            for (int i = 0; i < this.im; ++i) {
                for (int j = 0; j < this.jm; ++j) {
                    for (int k = 0; k < this.km; ++k) {
                        int oceanpoint = this.ijk2oceanpoint(i, j, k);
                        data3d[k][j][i] = oceanpoint >= 0 ? variable[oceanpoint] : 0.0f;
                    }
                }
            }
            nc.close();
        }
        catch (InvalidRangeException ex) {
            this.error("Error loading plankton variable " + this.planktonNetcdfNames[iPlankton] + " from file " + name, ex);
        }
        catch (IOException ex) {
            this.error("Error loading plankton variable " + this.planktonNetcdfNames[iPlankton] + " from file " + name, ex);
        }
        return this.verticalIntegration(data3d, this.depthOfLayer, this.getConfiguration().getFloat("ltl.integration.depth"));
    }

    @Override
    public int getIndexStepLTL(int iStepSimu) {
        return iStepSimu % this.getConfiguration().getNStepYear() / this.timeDim;
    }
}

