% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_user_data.R
\name{osm_details_logged_user}
\alias{osm_details_logged_user}
\title{Details of the logged-in user}
\usage{
osm_details_logged_user(format = c("R", "xml", "json"))
}
\arguments{
\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}.}
}
\value{
If \code{format = "R"}, returns a list with the user details.
\subsection{\code{format = "xml"}}{

Returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<osm version="0.6" generator="OpenStreetMap server">
  <user display_name="Max Muster" account_created="2006-07-21T19:28:26Z" id="1234">
    <contributor-terms agreed="true" pd="true"/>
    <img href="https://www.openstreetmap.org/attachments/users/images/000/000/1234/original/someLongURLOrOther.JPG"/>
    <roles></roles>
    <changesets count="4182"/>
    <traces count="513"/>
    <blocks>
      <received count="0" active="0"/>
    </blocks>
    <home lat="49.4733718952806" lon="8.89285988577866" zoom="3"/>
    <description>The description of your profile</description>
    <languages>
      <lang>de-DE</lang>
      <lang>de</lang>
      <lang>en-US</lang>
      <lang>en</lang>
    </languages>
    <messages>
      <received count="1" unread="0"/>
      <sent count="0"/>
    </messages>
  </user>
</osm>
}\if{html}{\out{</div>}}
}

\subsection{\code{format = "json"}}{

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "version": "0.6",
  "generator": "OpenStreetMap server",
  "user": \{
    "id": 1234,
    "display_name": "Max Muster",
    "account_created": "2006-07-21T19:28:26Z",
    "description": "The description of your profile",
    "contributor_terms": \{"agreed": True, "pd": True\},
    "img": \{"href": "https://www.openstreetmap.org/attachments/users/images/000/000/1234/original/someLongURLOrOther.JPG"\},
    "roles": [],
    "changesets": \{"count": 4182\},
    "traces": \{"count": 513\},
    "blocks": \{"received": \{"count": 0, "active": 0\}\},
    "home": \{"lat": 49.4733718952806, "lon": 8.89285988577866, "zoom": 3\},
    "languages": ["de-DE", "de", "en-US", "en"],
    "messages": \{"received": \{"count": 1, "unread": 0\},
    "sent": \{"count": 0\}\}
  \}
\}
}\if{html}{\out{</div>}}
}
}
\description{
You can get the home location, the display name of the user and other details.
}
\examples{
\dontrun{
usr_details <- osm_details_logged_user()
usr_details
}
}
\seealso{
Other users' functions: 
\code{\link{osm_get_preferences_user}()},
\code{\link{osm_get_user_details}()}
}
\concept{users' functions}
