% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_map_notes.R
\name{osm_create_note}
\alias{osm_create_note}
\title{Create a new note}
\usage{
osm_create_note(lat, lon, text, authenticate = TRUE)
}
\arguments{
\item{lat}{Specifies the latitude in decimal degrees of the note.}

\item{lon}{Specifies the longitude in decimal degrees of the note.}

\item{text}{A text field with arbitrary text containing the note.}

\item{authenticate}{If \code{TRUE} (default), the note is authored by the logged user. Otherwise, anonymous note.}
}
\value{
Returns a data frame with the map note (same format as \code{\link[=osm_get_notes]{osm_get_notes()}} with \code{format = "R"}).
}
\description{
Create a new note
}
\details{
If the request is made as an authenticated user, the note is associated to that user account. If the OAuth access
token used does not have the \code{allow_write_notes} permission, it is created as an anonymous note instead.
}
\examples{
\dontrun{
set_osmapi_connection("testing") # use the testing server
new_note <- osm_create_note(lat = 41.38373, lon = 2.18233, text = "Testing osmapiR")
new_note
}
}
\seealso{
Other edit notes' functions: 
\code{\link{osm_close_note}()},
\code{\link{osm_create_comment_note}()},
\code{\link{osm_delete_note}()}
}
\concept{edit notes' functions}
