% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows.R
\name{windows_credentials}
\alias{windows_credentials}
\alias{windows_item_types}
\alias{windows_item}
\alias{windows_item_read}
\alias{windows_item_write}
\alias{windows_item_delete}
\alias{windows_item_enumerate}
\title{Query and manipulate the Windows Credential Store}
\usage{
windows_item_types()

windows_item(
  credential_blob,
  target_name,
  type = "generic",
  comment = NULL,
  persist = c("local_machine", "session", "enterprise"),
  attributes = list(),
  target_alias = NULL,
  username = NULL
)

windows_item_read(target_name, type = "generic")

windows_item_write(item, preserve = FALSE)

windows_item_delete(target_name, type = "generic")

windows_item_enumerate(filter = NULL, all = FALSE)
}
\arguments{
\item{credential_blob}{The secret credential, a password,
certificate or key. See also
\url{https://docs.microsoft.com/en-us/windows/win32/api/wincred/ns-wincred-credentialw}
This can be a raw vector, or a string. If it is a string, then it
will be converted to Unicode, without the terminating zero.
It can also be \code{NULL}, to be used with the \code{preserve = TRUE}
argument of \code{windows_item_write()}.}

\item{target_name}{The name of the credential. The \code{target_name}
and \code{type} members uniquely identify the credential. This member
cannot be changed after the credential is created. Instead, the
credential with the old name should be deleted and the credential
with the new name created. This member cannot be longer than
\code{CRED_MAX_GENERIC_TARGET_NAME_LENGTH} (32767) characters.
This member is case-insensitive.}

\item{type}{The type of the credential. This member cannot be
changed after the credential is created. See \code{windows_item_types()}
for possible values.}

\item{comment}{If not \code{NULL}, then a string comment from the user
that describes this credential. This member cannot be longer than
\code{CRED_MAX_STRING_LENGTH} (256) characters. It is stored as a Unicode
string.}

\item{persist}{Defines the persistence of this credential.
\itemize{
\item \code{"local_machine"}: The credential persists for all subsequent
logon sessions on this same computer. It is visible to other
logon sessions of this same user on this same computer and not
visible to logon sessions for this user on other computers.
\item \code{"session"}: The credential persists for the life of the logon
session. It will not be visible to other logon sessions of this
same user. It will not exist after this user logs off and back on.
\item \code{"enterprise"}: The credential persists for all subsequent logon
sessions on this same computer. It is visible to other logon
sessions of this same user on this same computer and to logon
sessions for this user on other computers.
}}

\item{attributes}{Application-defined attributes that are
associated with the credential. This is \code{NULL} or a named list
of raw or string vectors. String vectors are converted to
Unicode, without the terminating zero. A credential can have at
most 64 attributes, the names of the attributes cannot be
longer than \code{CRED_MAX_STRING_LENGTH} (256) characters each, and
the attributes themselves cannot be longer than
\code{CRED_MAX_VALUE_SIZE} (256) bytes.}

\item{target_alias}{Alias for the \code{target_name} member.
This member can be read and written. It cannot be longer than
\code{CRED_MAX_STRING_LENGTH} (256) characters. It is stored in Unicode.}

\item{username}{\code{NULL} or the user name of the account used to
connect to \code{target_name}.}

\item{item}{\code{oskeyring_windows_item} object to write.}

\item{preserve}{The credential BLOB from an existing credential
is preserved with the same credential name and credential type.
The \code{credential_blob} of the passed \code{oskeyring_windows_item}
object must be \code{NULL}.}

\item{filter}{If not \code{NULL}, then a string to filter the
credentials. Only credentials with a \code{target_name} matching the
filter will be returned. The filter specifies a name prefix
followed by an asterisk. For instance, the filter \code{"FRED*"} will
return all credentials with a \code{target_name} beginning with the
string \code{"FRED"}.}

\item{all}{Whether to use the \code{CRED_ENUMERATE_ALL_CREDENTIALS}
flag to enumerate all credentials. If this is \code{TRUE}, then \code{filter}
must be \code{NULL}. If this is \code{TRUE}, then the target name of each
credential is returned in the \verb{"namespace:attribute=target}" format.}
}
\value{
\code{windows_item_types()} returns a character vector, the
currently supported credential types.

\code{windows_item()} returns an \code{oskeyring_windows_item}
object.

\code{windows_item_read()} returns an \code{oskeyring_windows_item}
object.

\code{windows_item_write()} returns \code{NULL}, invisibly.

\code{windows_item_delete()} returns \code{NULL}, invisibly.

\code{windows_item_enumerate()} returns a list of
\code{oskeyring_windows_item} items.
}
\description{
\verb{windows_item_*} functions read, write, delete and list
credentials.
}
\details{
\subsection{\code{windows_item_types()}}{

\code{windows_item_types()} lists the currently supported credential
types.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{windows_item_types()
#> [1] "generic"                 "domain_password"        
#> [3] "domain_certificate"      "domain_visible_password"
}\if{html}{\out{</div>}}
}

\subsection{\code{windows_item()}}{

\code{windows_item()} creates a Windows credential, that can be
then added to the credential store.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{it <- windows_item("secret", "my-host-password")
it
#> <oskeyring_windows_item: generic>
#>  target_name: my-host-password
#>  persist: local_machine
#>  credential_blob: <-- hidden -->
}\if{html}{\out{</div>}}
}

\subsection{\code{windows_item_write()}}{

Writes an item to the credential store.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{windows_item_write(it)
}\if{html}{\out{</div>}}
}

\subsection{\code{windows_item_read()}}{

Reads a credential with the specified type and \code{target_name}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{windows_item_read("my-host-password")
}\if{html}{\out{</div>}}
}

\subsection{\code{windows_item_enumerate()}}{

List all credentials that match a prefix.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{windows_item_enumerate(filter = "my-*")
}\if{html}{\out{</div>}}
}

\subsection{\code{windows_item_delete()}}{

Delete a credential:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{windows_item_delete("my-host-password")
windows_item_enumerate(filter = "my-*")
}\if{html}{\out{</div>}}
}
}
\examples{
# See above
}
\seealso{
The API documentation at
\url{https://docs.microsoft.com/en-us/windows/win32/api/wincred/}
}
