% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readS4.R
\name{readNIfTI}
\alias{readNIfTI}
\title{readNIfTI}
\usage{
readNIfTI(fname, verbose = FALSE, warn = -1, reorient = TRUE,
  call = NULL, force_extension = FALSE)
}
\arguments{
\item{fname}{is the file name of the NIfTI file(s).}

\item{verbose}{is a logical variable (default = \code{FALSE}) that allows
text-based feedback during execution of the function.}

\item{warn}{is a number to regulate the display of warnings (default = -1).
See \code{options} for more details.}

\item{reorient}{is a logical variable (default = \code{TRUE}) that enforces
Qform/Sform transformations.}

\item{call}{keeps track of the current function call for use in the NIfTI
extension.}

\item{force_extension}{this function will check to see if the 
\code{vox_offset} is correct.  If this is forced to \code{348}, which some 
(very) old NIfTI writers use, this may cause an error if the extension is read,
and so it is skipped (with a warning). If \code{force_extension = TRUE},
then reading the extension is forced (when appropriate).}
}
\value{
An object of class \code{nifti}.
}
\description{
These functions read in the header information and multidimensional array
from a binary file in NIfTI-1 format into a \code{\linkS4class{nifti}}-class
object.
}
\details{
The \code{readNIfTI} function utilizes internal methods \code{readBin} and
\code{readChar} to efficiently extract information from the binary file(s).

Current acceptable data types include \describe{ \item{list("UINT8")}{BINARY
(1 bit per voxel)} \item{list("INT16")}{SIGNED SHORT (16 bits per voxel)}
\item{list("INT32")}{SINGED INT (32 bits per voxel)}
\item{list("FLOAT32")}{FLOAT (32 bits per voxel)}
\item{list("DOUBLE64")}{DOUBLE (64 bits per voxel)}
\item{list("UINT16")}{UNSIGNED SHORT (16 bits per voxel)}
\item{list("UINT32")}{UNSIGNED INT (32 bits per voxel)} }
}
\examples{

\dontrun{
url <- "http://nifti.nimh.nih.gov/nifti-1/data/filtered_func_data.nii.gz"
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "filtered_func_data")
download.file(url, urlfile, quiet=TRUE)
}
## The NIfTI file provided here contains the first 18 volumes (10\%)
## of the original data set
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "filtered_func_data")
(ffd <- readNIfTI(urlfile))
image(ffd, oma=rep(2,4))
orthographic(ffd, oma=rep(2,4))
\dontrun{
## 27 scans of Colin Holmes (MNI) brain co-registered and averaged
## NIfTI two-file format
URL <- "http://imaging.mrc-cbu.cam.ac.uk/downloads/Colin/colin_1mm.tgz"
urlfile <- file.path(tempdir(), "colin_1mm.tgz")
download.file(URL, dest=urlfile, quiet=TRUE)
untar(urlfile, exdir=tempdir())
colin <- readNIfTI(file.path(tempdir(), "colin_1mm"))
image(colin, oma=rep(2,4))
orthographic(colin, oma=rep(2,4))
}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com},\cr Volker Schmid
\email{volkerschmid@users.sourceforge.net},\cr Andrew Thornton
\email{zeripath@users.sourceforge.net}
}
\references{
NIfTI-1\cr \url{http://nifti.nimh.nih.gov/}
}
\seealso{
\code{\link{readAFNI}}, \code{\link{readANALYZE}}
}
\keyword{file}

