% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_file.R
\docType{methods}
\name{aux_file-methods}
\alias{aux.file}
\alias{aux.file,anlz-method}
\alias{aux.file,nifti-method}
\alias{aux.file<-}
\alias{aux.file<-,anlz-method}
\alias{aux.file<-,nifti-method}
\alias{aux_file}
\alias{aux_file,anlz-method}
\alias{aux_file,nifti-method}
\alias{aux_file-methods}
\alias{aux_file-methods,}
\alias{aux_file<-}
\alias{aux_file<-,anlz-method}
\alias{aux_file<-,nifti-method}
\title{Extract Image Attribute \code{aux_file}}
\usage{
aux_file(object)

\S4method{aux_file}{nifti}(object)

\S4method{aux_file}{anlz}(object)

aux_file(object) <- value

\S4method{aux_file}{nifti}(object) <- value

\S4method{aux_file}{anlz}(object) <- value

aux.file(object)

\S4method{aux.file}{nifti}(object)

\S4method{aux.file}{anlz}(object)

aux.file(object) <- value

\S4method{aux.file}{nifti}(object) <- value

\S4method{aux.file}{anlz}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{aux_file} field.}
}
\description{
Methods that act on the \code{aux_file} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
\dontrun{
url <- "http://nifti.nimh.nih.gov/nifti-1/data/avg152T1_RL_nifti.nii.gz"
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                    "mniRL.nii.gz")
download.file(url, urlfile, quiet=TRUE)
}
options("niftiAuditTrail"=FALSE)

urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniRL.nii.gz")
mniRL <- readNIfTI(urlfile)
aux.file(mniRL)
aux.file(mniRL) <- "avg152T1_RL_nifti"
aux.file(mniRL)
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
ANALYZE 7.5\cr
\url{https://rportal.mayo.edu/bir/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}

