% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsr.R
\name{nsr}
\alias{nsr}
\title{Search the Native Species Resolver}
\usage{
nsr(species, country, stateprovince = NULL, countyparish = NULL, ...)
}
\arguments{
\item{species}{(character) One or more species names. required.}

\item{country}{(character) A country name. required.}

\item{stateprovince}{(character) A state or province name}

\item{countyparish}{(character) A county or parish name}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Search the Native Species Resolver
}
\details{
Currently, only one name is allowed per request. We loop internally
over a list of length > 1, but this will still be slow due to only 1
name per request.

Note that this service can be quite slow.
}
\section{political names}{

\itemize{
\item \code{nsr_countries}: is a vector of country names that we use to check
your country names
\item \code{nsr_pol_divisions}: is a data.frame of country names and state/province
names that we used to check your parameter inputs - these are for checklists
that NSR has complete coverage for
}
}

\examples{
\dontrun{
nsr("Pinus ponderosa", country = "United States")
nsr(c("Pinus ponderosa", "Poa annua"), country = "United States")
splist <- c("Pinus ponderosa", "Poa annua", "bromus tectorum", "Ailanthus altissima")
nsr(splist, country = "United States")
nsr(splist, country = "United States", stateprovince = "California")

# curl options
nsr("Pinus ponderosa", "United States", verbose = TRUE)
}
}
\references{
http://bien.nceas.ucsb.edu/bien/tools/nsr/nsr-ws/
}
