% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_mbetag.R
\name{order_mbetag}
\alias{order_mbetag}
\title{Random Sampling of Order Statistics from a Modified Beta G Distribution}
\usage{
order_mbetag(size, spec, beta, a, b, k, n, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{spec}{character, represents an specific G distribution. Possible values "norm", "exp","lnorm","chisq".}

\item{beta}{numeric, represents the scale parameter. Default value is 1.}

\item{a}{numeric, represents a shape parameter must be positive. Default value is 1.}

\item{b}{numeric, represents a shape parameter must be positive. Default value is 1.}

\item{k}{numeric, represents the Kth smallest value from a sample.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{...}{represents others parameters of the G distribution.}
}
\value{
A list with a random sample of order statistics from a Modified Beta G Distribution and the value of its join probability density function evaluated in the random sample.
}
\description{
\code{order_mbetag} is used to obtain a random sample of order statistics from a Modified Beta G Distribution.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from
# a Modified Beta Exponential Distribution
order_mbetag(10,"exp",1,1,1,k=3,50)
# A sample of size 10 of the 3-th order statistics from
# a Modified Beta Normal Distribution
order_mbetag(10,"norm",1,1,1,k=3,50)
# A sample of size 10 of the 3-th order statistics from
# a Modified Beta Log-normal Distribution
order_mbetag(10,"lnorm",1,1,1,k=3,50)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Naradajah, S. and Rocha, R. (2016) Newdistns: An R Package for New Families of Distributions, Journal of Statistical Software.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
