% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_run.R
\name{orderly_run}
\alias{orderly_run}
\title{Run a report}
\usage{
orderly_run(
  name = NULL,
  parameters = NULL,
  envir = NULL,
  root = NULL,
  locate = TRUE,
  echo = TRUE,
  message = NULL,
  instance = NULL,
  use_draft = FALSE,
  remote = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{Name of the report to run (see
\code{\link[=orderly_list]{orderly_list()}}).  A leading \verb{src/} will be
removed if provided, allowing easier use of autocomplete.
Alternatively, the default of \code{NULL} is useful if you have
already set the working directory to be the source directory.}

\item{parameters}{Parameters passed to the report. A named list of
parameters declared in the \code{orderly.yml}.  Each parameter
must be a scalar character, numeric, integer or logical.}

\item{envir}{The parent of the environment that will be used to
evaluate the report script; by default a new environment will be
made with the global environment as the parent.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{echo}{Print the result of running the R code to the console}

\item{message}{An optional character string containing a message
explaining why the report was run}

\item{instance}{Select instance of the source database to be used,
where multiple instances are configured.  Use a single
\emph{unnamed} character string to indicate an instance to
match.  If given, then this name must be present in all
databases where instances are listed in
\code{orderly_config.yml}, and will be ignored by all database
where instances are not given.  See the "orderly" vignette for
further information.}

\item{use_draft}{Should draft reports be used for dependencies?
This should be used only in development.  Valid values are
logical (\code{TRUE}, \code{FALSE}) or use the string
\code{newer} to use draft reports where they are newer than
archive reports.  For consistency, \code{always} and
\code{never} are equivalent to \code{TRUE} and \code{FALSE},
respectively.}

\item{remote}{Remote to use to resolve dependencies.  Use this in
order to run a report with the same dependencies as are
available on a remote server, particularly when using \code{id = "latest"}.  Note that this is not the same as running
\code{\link[=orderly_pull_dependencies]{orderly_pull_dependencies()}}, then \code{orderly_run}
with \code{remote = NULL}, as the pull/run approach will use the
latest report in \emph{your} archive but the \code{remote = "remote"} approach will use the latest approach in the
\emph{remote} archive (which might be less recent).}

\item{tags}{Character vector of tags to add to the report.  Tags
are immutable and cannot be removed once the report is run.
Tags added here will be \emph{in addition} to any tags listed in
the \verb{tags:} field in \code{orderly.yml} and must be present
in \code{orderly_config.yml}.}
}
\value{
The id of the newly created report
}
\description{
Run a report.  This will create a new directory in
\verb{drafts/<reportname>}, copy your declared resources there,
extract data from databases (if you are using them), run your
script and check that all expected artefacts were created.  Once
successfully run you can use \code{\link[=orderly_commit]{orderly_commit()}} to move
it to the \code{archive} directory.
}
\details{
Parameters are passed to the report as a named list, for example\preformatted{id <- orderly::orderly_run("other", list(nmin = 0.2), root = path)
}

(see the examples).  The names of the parameters (here,
\code{nmin}) must correspond to declared parameters in the
\code{orderly.yml}.  It is an error if parameters without a
default are omitted, and it is an error if unknown parameters are
provided.

Environment variables that are created in \code{orderly_envir.yml}
will be available while the report runs.  Those that begin with
\code{ORDERLY_} will be saved into the \code{orderly_run.rds}
within the \verb{$env} section (except for any that match the
patterns "TOKEN", "PAT" or "PASS").
}
\examples{
path <- orderly::orderly_example("demo")

# To run most reports, provide the report name (and the path if
# not running in the working directory, as is the case here):
id <- orderly::orderly_run("minimal", root = path)

# Every report gets a unique identifier, based on the time (it is
# ISO 8601 time with random hex appended to end)
id

# After being run, a report is a "draft" and will exist in the
# drafts directory:
orderly::orderly_list_drafts(root = path)

# Draft reports are always stored in the path
# <root>/draft/<name>/<id>, so we have
dir(file.path(path, "draft", "minimal", id))

# which contains the files when the report was run.

# If a report has parameters, then these must be passed in as a
# named list.
id <- orderly::orderly_run("other", list(nmin = 0.2), root = path)

# These parameters can be used in SQL queries or in the report
# code.
}
\seealso{
\code{\link[=orderly_log]{orderly_log()}} for controlling display of log
messages (not just R output)
}
