% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_stratum.R
\name{split_stratum}
\alias{split_stratum}
\title{Split one stratum into multiple strata}
\usage{
split_stratum(
  z,
  X,
  strata,
  ist,
  nc,
  nt,
  wMax = 5,
  wEach = 1,
  solver = "Rglpk",
  integer = FALSE,
  threads = NULL
)
}
\arguments{
\item{z}{Vector of treatment assignment}

\item{X}{Covariate matrix or data.frame}

\item{strata}{vector of initial strata assignments; only used if \code{object} is not supplied.
Can be \code{NULL}, in which case an initial stratification using the quintiles of the
propensity score is generated using \code{\link{prop_strat}()} and the generated
propensity score is also added to the X matrix as an extra covariate}

\item{ist}{the stratum to be split}

\item{nc}{a vector stating how many control units to place in
each of the new split strata. The sum must be the total number of controls
in the stratum to be split}

\item{nt}{a vector stating how many treated units to place in
each of the new split strata. The sum must be the total number of treated units
in the stratum to be split}

\item{wMax}{the weight the objective places on the maximum epsilon}

\item{wEach}{the weight the objective places on each epsilon}

\item{solver}{character specifying the optimization software to use.
Options are "Rglpk" or "gurobi". The default is "gurobi"}

\item{integer}{boolean whether to use integer programming instead of randomized rounding.
Default is \code{FALSE}. It is not recommended to set this to \code{TRUE} as the problem may never finish}

\item{threads}{how many threads to use in the optimization if using "gurobi" as the solver. Default will use all available threads}
}
\value{
A list containing the following elements:
\itemize{
\item{valueIP, valueLP: }{integer and linear programming scaled objective values}
\item{n_smds: }{number of standardized mean differences contributing to the objective values
(multiply the scaled objective values by this number to get the true objective values)}
\item{n_fracs: }{the number of units with fractional linear programming solutions}
\item{rand_c_prop, rand_t_prop: }{proportions of the control and treated units in each stratum
that were selected with randomness}
\item{pr: }{linear programming solution, with rows corresponding to the strata and columns to the units}
\item{selection: }{vector of selected strata for each unit in the initial stratum to be split}
}
}
\description{
Split one stratum into multiple with specified sample sizes.
}
\examples{
# Generate a small data set
set.seed(25)
samp <- sample(1:nrow(rhc_X), 1000)
cov_samp <- sample(1:26, 10)

# Create some strata
ps <- prop_strat(z = rhc_X[samp, "z"],
                 X = rhc_X[samp, cov_samp], nstrata = 5)

# Save the sample sizes
tab <- table(ps$z, ps$base_strata)

# Choose the best sample sizes among the options provided
split_stratum(z = ps$z, X = ps$X, strata = ps$base_strata, ist = 1,
           nc = c(floor(tab[1, 1] * 0.25), ceiling(tab[1, 1] * 0.75)),
           nt = c(floor(tab[2, 1] * 0.3), ceiling(tab[2, 1] * 0.7)))

}
