\name{stride}
\alias{stride}
\alias{plot.stride}
\alias{silhouette.stride}
\title{Stride: Producing a Sequence of Clusterings}

\description{stride proceeds along a specified sequence creating clusterings or
partitions of a dissimilarity matrix for each value of the sequence.}

\usage{
stride(seq,arg2,type='pam',numrep=10,maxitr=100)
\method{plot}{stride}(x, dist, col2=4, \dots)
\method{silhouette}{stride}(x,dist,\dots)
}
\arguments{
\item{seq}{a sequence, in either a:b or seq(a,b,c) form}
\item{arg2}{an object of class \sQuote{dist} from \code{\link{dist}},
\code{\link[labdsv]{dsvdis}} or \code{\link[vegan]{vegdist}} among other
sources, or of class \sQuote{hclust}}
\item{type}{if arg2 is an object of class \sQuote{dist}, type specifies the
algorithm to produce clusters, and can be either \sQuote{pam} or \sQuote{optpart}.}
\item{numrep}{if arg2 is an object of class \sQuote{dist} and type =
\sQuote{optpart}, numrep specifies the number of replicates to run in function 
\code{\link[optpart]{optpart}}.}
\item{maxitr}{if arg2 is an object of class \sQuote{dist} and type = 
\sQuote{optpart} numrep specifies the maximum number of iterations per replicate 
 in function
\code{\link[optpart]{optpart}}}
\item{x}{an object of class \sQuote{stride}}
\item{dist}{an object of class \sQuote{dist} from \code{\link{dist}}, 
\code{\link[labdsv]{dsvdis}}, or \code{\link[vegan]{vegdist}}}
\item{col2}{the color code for the second line in the graph}
\item{\dots}{ancillary arguments to the plot or silhouette functions}
}

\details{
The specific action of function stride depends on the class of the second
argument.  If arg2 is of class \sQuote{dist}, then clusters are generated by
a fixed cluster algorithm.  In this case, if type is \sQuote{pam}, the 
function \code{\link[cluster]{pam}} is called to
produce the clusters.  If type is \sQuote{optpart} the function
\code{\link[optpart]{optpart}} is called to produce the clusters.
If arg2 is of class \sQuote{hclust}, then the hlcust object is successively
\sQuote{sliced} at levels specified by the sequence.  The object of class
\sQuote{hclust} can result from the function \code{hclust} using any of the
methods provided, or by casting an object of class \sQuote{partition} to class
\sQuote{hlcust} with the \code{as.hclust} function.

The default plot method for a stride plots the partana ratios 
(see \code{\link[optpart]{partana}}) of each partition of the sequence on the left Y axis, 
and the silhouette widths of the same partitions on the right Y axis.
}

\value{
an object of class \sQuote{stride}, which is a list with components:
\item{clustering}{a data.frame with items as rows, and cluster IDs as columns,
with one column for each value of the sequence}
\item{seq}{a copy of the sequence employed}
}

\author{David W. Roberts \email{droberts@montana.edu}}

\examples{
data(shoshveg)
dis.bc <- dsvdis(shoshveg,'bray')
results <- stride(2:5,dis.bc)
}

\keyword{cluster}
\keyword{hplot}




