% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_lists.R
\name{op_lists}
\alias{op_lists}
\title{Optimos Prime calculates optima and tolerance for a matrix of species and environmental factors}
\usage{
op_lists(enviromental_df, species_df, listOnly = 0)
}
\arguments{
\item{enviromental_df}{The dataframe with your environmental data. Variables as rows, Sites as columns}

\item{species_df}{The dataframe with your species densities. Species as rows, Sites as columns.}

\item{listOnly}{Which lists to return. If = 0, then returns all three lists combined (Sites, Species, Environmental). If = 1, it returns only lists of Sites. If = 2, it returns only list of Species. If = 3, it returns only list of Environmental parameters.}
}
\description{
You will need two dataframes. If they are not specified as arguments, you will be prompted to import them from CSV format.

\itemize{
\item Matrix 1: Species (rows) by Sampling sites (columns).
    First row needs to be the sampling sites names.
    First column needs to be the species' names.
    Values in cells therefore need to be the density of each species at each site.
\item Matrix 2: Environmental variables (rows) by Sampling sites (columns).
    First row needs to be the sampling sites names.
    First column needs to be the names of the environmental variables (i.e. physical-chemical parameters).
    Values in cells therefore need to be the value of each environmental variable at each site.
}
}
\details{
This function (op_lists) generates three lists from your dataframes: a species list, an environmental factors list and a sample (or sampling sites) list
}
\keyword{density}
\keyword{ecology,}
\keyword{optimum,}
\keyword{species}
\keyword{tolerance,}
