% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoSearch.R
\name{autoSearch}
\alias{autoSearch}
\title{Optimize all possible indicator combinations}
\usage{
autoSearch(
  coefTable,
  landUseObs,
  uValue = 1,
  optimisticRule = "expectation",
  fixDistance = 3
)
}
\arguments{
\item{coefTable}{Coefficient table in the expected \emph{optimLanduse} format.}

\item{landUseObs}{Data frame with two columns. The first column has to
contain the land-use options. The second column the respective shares.}

\item{uValue}{\emph{u} Value. The uncertainty value delivered in the coefTable is
multiplied with this u value. The value, therefore, enables scenario analyses with differing
uncertainties in relation to indicator values. Higher u values can be interpreted as a higher
risk aversion of the decision maker.}

\item{optimisticRule}{Either \emph{expectation} or \emph{uncertaintyAdjustedExpectation}.
The rule indicates whether the optimistic outcomes of an indicator are directly
reflected by their expectations or if the indicator is calculated as expectation +
uncertainty when "more is better" or expectation - uncertainty respectively when "less is better".
An optimization based on \emph{expectation} considers only downside risks.}

\item{fixDistance}{This optional numeric value allows to define distinct uncertainty levels for the
calculation of the uncertainty space and the averaged distances of a certain land-cover composition
(see Equation 9 in Husmann et al. (2020)). Passing NA disables fixDistance. In this case,
the uncertainty space is defined by uValue.}
}
\value{
A list with all possible indicator combinations, their respective optimization results and the
indicator set best describing the observed land-use decision.
}
\description{
This iterative search function generates a list of all possible indicator combinations.
All indicator combinations are converted into a list format, where each
combination corresponds to a list entry. For each of these list entries, an
optimization is performed using the \emph{initScenario} and
\emph{solveScenario} functions of the package. How these functions work
in detail (incl. example code) can be seen in the help of the respective
function in the package and the README from Husmann et al. (2022).
The results are entirely saved into the respective list entry. In addition, each entry is
appended with the currently observed land-use portfolio and the land-use
portfolio when all indicators are optimized together. Out of this list, we
use the Bray-Curtis measure of dissimilarity to identify the indicators driving current
land-use decisions. An example and further explanation is given in the README
\href{https://github.com/Forest-Economics-Goettingen/optimLanduse/}{GitHub project page}
}
\examples{
require(readxl)
require(future.apply)
plan(multisession)

coefTable <- read_xlsx(exampleData("exampleGosling.xlsx"))

# Subset to save computation time

coefTable <- coefTable[coefTable$indicator \%in\% c("Long-term income",
                                                 "Liquidity",
                                                 "Protecting soil resources"),]

obsLU <- data.frame(landUse = c("Pasture", "Crops", "Forest", "Plantation",
                                "Alley Cropping", "Silvopasture"),
                    share = c(0.59, 0.26, 0.14, 0.01, 0, 0))

combList <- autoSearch(coefTable = coefTable,
                       landUseObs = obsLU,
                       uValue = 2,
                       optimisticRule = "expectation",
                       fixDistance = 3)
plan(sequential)

}
\references{
Husmann, K., von Groß, V., Bödeker, K., Fuchs, J. M., Paul, C., & Knoke, T. (2022). optimLanduse: A package for multiobjective land-cover composition optimization under uncertainty. Methods in Ecology and Evolution, 00, 1– 10. https://doi.org/10.1111/2041-210X.14000
}
