% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ProjectProblem}
\alias{plot.ProjectProblem}
\title{Plot a solution to a project prioritization problem}
\usage{
\method{plot}{ProjectProblem}(x, solution, n = 1, symbol_hjust = 0.007,
  return_data = FALSE, ...)
}
\arguments{
\item{x}{project prioritization \code{\link{problem}}.}

\item{solution}{\code{\link[base]{data.frame}} or
\code{\link[tibble]{tibble}} table containing the solutions. Here,
rows correspond to different solutions and columns correspond to
different actions. Each column in the argument to \code{solution} should
be named according to a different action in \code{x}.
Cell values indicate if an action is funded in a given solution or not,
and should be either zero or one. Arguments to \code{solution} can
contain additional columns, and they will be ignored.}

\item{n}{\code{integer} solution number to visualize.
Since each row in the argument to \code{solutions} corresponds to a
different solution, this argument should correspond to a row in
the argument to \code{solutions}. Defaults to 1.}

\item{symbol_hjust}{\code{numeric} horizontal adjustment parameter to
manually align the asterisks and dashes in the plot. Defaults to
\code{0.007}. Increasing this parameter will shift the symbols further
right. Please note that this parameter may require some tweaking
to produce visually appealing publication quality plots.}

\item{return_data}{\code{logical} should the underlying data used to create
the plot be returned instead of the plot? Defaults to \code{FALSE}.}

\item{...}{not used.}
}
\value{
A \code{\link{ggplot}} object.
}
\description{
Create a plot to visualize how well a solution to a project prioritization
problem will maintain biodiversity.
}
\details{
The type of plot that this function creates depends on the
  problem objective. If the problem objective contains phylogenetic data,
  then this function plots a phylogenetic tree where each branch
  is colored according to its probability of persistence. Otherwise,
  if the problem does not contain phylogenetic data, then this function
  creates a bar plot where each bar corresponds to a different feature.
  The height of the bars indicate each feature's probability of
  persistence, and the width of the bars indicate each feature's weight.

  Features that directly benefit from at least a single
  completely funded project with a non-zero cost are depicted with an
  asterisk symbol. Additionally, features that indirectly benefit from funded
  projects---because they are associated with partially funded projects that
  have non-zero costs and share actions with at least one funded
  project---are depicted with an open circle symbol.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem without phylogenetic data
p1 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_max_richness_objective(budget = 400) \%>\%
      add_feature_weights("weight") \%>\%
      add_binary_decisions()

# solve problem without phylogenetic data
s1 <- solve(p1)

# visualize solution without phylogenetic data
plot(p1, s1)

\donttest{
# build problem with phylogenetic data
p2 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_max_phylo_div_objective(budget = 400, sim_tree) \%>\%
      add_binary_decisions()

# solve problem with phylogenetic data
s2 <- solve(p2)

# visualize solution with phylogenetic data
plot(p2, s2)
}
}
\seealso{
This function is essentially a wrapper for
  \code{\link{plot_feature_persistence}} and
  \code{\link{plot_phylo_persistence}}, so refer to the documentation
  for these functions for more information.
}
