% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_save}
\alias{wb_save}
\title{Save a workbook to file}
\usage{
wb_save(wb, file = NULL, overwrite = TRUE, path = NULL)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object to write to file}

\item{file}{A path to save the workbook to}

\item{overwrite}{If \code{FALSE}, will not overwrite when \code{file} already exists.}

\item{path}{Deprecated argument. Please use \code{file} in new code.}
}
\value{
the \code{wbWorkbook} object, invisibly
}
\description{
Save a workbook to file
}
\examples{
## Create a new workbook and add a worksheet
wb <- wb_workbook("Creator of workbook")
wb$add_worksheet(sheet = "My first worksheet")

## Save workbook to working directory
\donttest{
wb_save(wb, file = temp_xlsx(), overwrite = TRUE)
}
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
