% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{base_font-wb}
\alias{base_font-wb}
\alias{wb_set_base_font}
\alias{wb_get_base_font}
\title{Set the default font in a workbook}
\usage{
wb_set_base_font(
  wb,
  font_size = 11,
  font_color = wb_color(theme = "1"),
  font_name = "Calibri",
  ...
)

wb_get_base_font(wb)
}
\arguments{
\item{wb}{A workbook object}

\item{font_size}{Font size}

\item{font_color}{Font color}

\item{font_name}{Name of a font}

\item{...}{Additional arguments}
}
\description{
Modify / get the default font for the workbook. The base font in a workbook
does not affect the font in data tables.
}
\details{
The font name is not validated in anyway. Excel replaces unknown font names
with Arial. The default base font is Calibri, black, size 11.
}
\examples{
## create a workbook
wb <- wb_workbook()
wb$add_worksheet("S1")
## modify base font to size 10 Arial Narrow in red
wb$set_base_font(font_size = 10, font_color = wb_color("red"), font_name = "Arial Narrow")

wb$add_data(x = iris)

## font color does not affect tables
wb$add_data_table(x = iris, dims = wb_dims(from_col = 10))

## get the base font
wb_get_base_font(wb)

}
\seealso{
Other workbook styling functions: 
\code{\link{wb_add_dxfs_style}()},
\code{\link{wb_add_style}()}

Other workbook wrappers: 
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook styling functions}
\concept{workbook wrappers}
