% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_creators}
\alias{wb_creators}
\alias{wb_add_creators}
\alias{wb_set_creators}
\alias{wb_remove_creators}
\alias{wb_get_creators}
\title{Workbook creators}
\usage{
wb_add_creators(wb, creators)

wb_set_creators(wb, creators)

wb_remove_creators(wb, creators)

wb_get_creators(wb)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object}

\item{creators}{A character vector of names}
}
\value{
\itemize{
\item \code{wb_set_creators()}, \code{wb_add_creators()}, and \code{wb_remove_creators()} return the \code{wbWorkbook} object
\item \code{wb_get_creators()} returns a \code{character} vector of creators
}
}
\description{
Modify and get workbook creators
}
\examples{

# workbook made with default creator (see [wbWorkbook])
wb <- wb_workbook()
wb_get_creators(wb)

# add a new creator (assuming "test" isn't your default creator)
wb <- wb_add_creators(wb, "test")
wb_get_creators(wb)

# remove the creator (should be the same as before)
wb <- wb_remove_creators(wb, "test")
wb_get_creators(wb)

}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_font}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_col_widths}},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_grouping}},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
