% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_sheetview}
\alias{wb_set_sheetview}
\title{add sheetview}
\usage{
wb_set_sheetview(
  wb,
  sheet = current_sheet(),
  colorId = NULL,
  defaultGridColor = NULL,
  rightToLeft = NULL,
  showFormulas = NULL,
  showGridLines = NULL,
  showOutlineSymbols = NULL,
  showRowColHeaders = NULL,
  showRuler = NULL,
  showWhiteSpace = NULL,
  showZeros = NULL,
  tabSelected = NULL,
  topLeftCell = NULL,
  view = NULL,
  windowProtection = NULL,
  workbookViewId = NULL,
  zoomScale = NULL,
  zoomScaleNormal = NULL,
  zoomScalePageLayoutView = NULL,
  zoomScaleSheetLayoutView = NULL
)
}
\arguments{
\item{wb}{workbook}

\item{sheet}{sheet}

\item{colorId, defaultGridColor}{Integer: A color, default is 64}

\item{rightToLeft}{Logical: if TRUE column ordering is right  to left}

\item{showFormulas}{Logical: if TRUE cell formulas are shown}

\item{showGridLines}{Logical: if TRUE the worksheet grid is shown}

\item{showOutlineSymbols}{Logical: if TRUE outline symbols are shown}

\item{showRowColHeaders}{Logical: if TRUE row and column headers are shown}

\item{showRuler}{Logical: if TRUE a ruler is shown in page layout view}

\item{showWhiteSpace}{Logical: if TRUE margins are shown in page layout view}

\item{showZeros}{Logical: if FALSE cells containing zero are shown blank if !showFormulas}

\item{tabSelected}{Integer: zero vector indicating the selected tab}

\item{topLeftCell}{Cell: the cell shown in the top left corner / or top right with rightToLeft}

\item{view}{View: "normal", "pageBreakPreview" or "pageLayout"}

\item{windowProtection}{Logical: if TRUE the panes are protected}

\item{workbookViewId}{integer: Pointing to some other view inside the workbook}

\item{zoomScale, zoomScaleNormal, zoomScalePageLayoutView, zoomScaleSheetLayoutView}{Integer: the zoom scale should be between 10 and 400. These are values for current, normal etc.}
}
\value{
The \code{wbWorksheetObject}, invisibly
}
\description{
add sheetview
}
\examples{
wb <- wb_workbook()$add_worksheet()

wb$set_sheetview(
  zoomScale = 75,
  rightToLeft = FALSE,
  showFormulas = TRUE,
  showGridLines = TRUE,
  showOutlineSymbols = FALSE,
  showRowColHeaders = TRUE,
  showRuler = TRUE,
  showWhiteSpace = FALSE,
  tabSelected = 1,
  topLeftCell = "B1",
  view = "normal",
  windowProtection = TRUE
)
}
