% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_save}
\alias{wb_save}
\title{Save Workbook to file}
\usage{
wb_save(wb, path = NULL, overwrite = TRUE)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object to write to file}

\item{path}{A path to save the workbook to}

\item{overwrite}{If \code{FALSE}, will not overwrite when \code{path} exists}
}
\value{
the \code{wbWorkbook} object, invisibly
}
\description{
Save Workbook to file
}
\examples{
## Create a new workbook and add a worksheet
wb <- wb_workbook("Creator of workbook")
wb$add_worksheet(sheet = "My first worksheet")

## Save workbook to working directory
\donttest{
wb_save(wb, path = temp_xlsx(), overwrite = TRUE)
}
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
