% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_conditional_formatting}
\alias{wb_add_conditional_formatting}
\alias{wb_conditional_formatting}
\title{Add conditional formatting to cells}
\usage{
wb_add_conditional_formatting(
  wb,
  sheet = current_sheet(),
  cols,
  rows,
  rule = NULL,
  style = NULL,
  type = c("expression", "colorScale", "dataBar", "duplicatedValues", "containsText",
    "notContainsText", "beginsWith", "endsWith", "between", "topN", "bottomN"),
  params = list(showValue = TRUE, gradient = TRUE, border = TRUE, percent = FALSE, rank =
    5L)
)

wb_conditional_formatting(
  wb,
  sheet,
  cols,
  rows,
  rule = NULL,
  style = NULL,
  type = c("expression", "colorScale", "dataBar", "duplicatedValues", "containsText",
    "notContainsText", "beginsWith", "endsWith", "between", "topN", "bottomN"),
  ...
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{Columns to apply conditional formatting to}

\item{rows}{Rows to apply conditional formatting to}

\item{rule}{The condition under which to apply the formatting. See examples.}

\item{style}{A style to apply to those cells that satisfy the rule. Default is 'font_color = "FF9C0006"' and 'bgFill = "FFFFC7CE"'}

\item{type}{The type of conditional formatting rule to apply.}

\item{params}{Additional parameters passed.  See \strong{Details} for more}

\item{...}{passed to \code{params}}
}
\description{
Add conditional formatting to cells
}
\details{
See Examples.

Conditional formatting types accept different parameters.  Unless noted,
unlisted parameters are ignored.

\describe{
\item{\code{expression}}{
\verb{[style]}\cr A \code{Style} object\cr\cr
\verb{[rule]}\cr An Excel expression (as a character). Valid operators are: \code{<}, \code{<=}, \code{>}, \code{>=}, \code{==}, \code{!=}
}
\item{colorScale}{
\verb{[style]}\cr A \code{character} vector of valid colors with length \code{2} or \code{3}\cr\cr
\verb{[rule]}\cr \code{NULL} or a \code{character} vector of valid colors of equal length to \code{styles}
}
\item{dataBar}{
\verb{[style]}\cr A \code{character} vector of valid colors with length \code{2} or \code{3}\cr\cr
\verb{[rule]}\cr A \code{numeric} vector specifying the range of the databar colors. Must be equal length to \code{style}\cr\cr
\verb{[params$showValue]}\cr If \code{FALSE} the cell value is hidden. Default \code{TRUE}\cr\cr
\verb{[params$gradient]}\cr If \code{FALSE} colour gradient is removed. Default \code{TRUE}\cr\cr
\verb{[params$border]}\cr If \code{FALSE} the border around the database is hidden. Default \code{TRUE}
}
\item{duplicated}{
\verb{[style]}\cr A \code{Style} object
}
\item{contains}{
\verb{[style]}\cr A \code{Style} object\cr\cr
\verb{[rule]}\cr The text to look for within cells
}
\item{between}{
\verb{[style]}\cr A Style object.\cr\cr
\verb{[rule]}\cr A \code{numeric} vector of length \code{2} specifying lower and upper bound (Inclusive)
}
\item{topN}{
\verb{[style]}\cr A \code{Style} object\cr\cr
\verb{[params$rank]}\cr A \code{numeric} vector of length \code{1} indicating number of highest values. Default \code{5L}\cr\cr
\verb{[params$percent]} If \code{TRUE} uses percentage
}
\item{bottomN}{
\verb{[style]}\cr A \code{Style} object\cr\cr
\verb{[params$rank]}\cr A \code{numeric} vector of length \code{1} indicating number of lowest values. Default \code{5L}\cr\cr
\verb{[params$percent]}\cr If \code{TRUE} uses percentage
}
}
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("a")
wb$add_data("a", 1:4, colNames = FALSE)
wb$add_conditional_formatting("a", 1, 1:4, ">2")
}
