% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wrappers.R
\name{addFilter}
\alias{addFilter}
\title{add filters to columns}
\usage{
addFilter(wb, sheet, rows, cols)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{rows}{A row number.}

\item{cols}{columns to add filter to.}
}
\description{
add filters to columns
}
\details{
adds filters to worksheet columns, same as filter parameters in writeData.
writeDataTable automatically adds filters to first row of a table.
NOTE Can only have a single filter per worksheet unless using tables.
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "Sheet 1")
addWorksheet(wb, "Sheet 2")
addWorksheet(wb, "Sheet 3")

writeData(wb, 1, iris)
addFilter(wb, 1, row = 1, cols = 1:ncol(iris))

## Equivalently
writeData(wb, 2, x = iris, withFilter = TRUE)

## Similarly
writeDataTable(wb, 3, iris)

saveWorkbook(wb, file = "addFilterExample.xlsx", overwrite = TRUE)
}
\seealso{
\code{\link{writeData}}

\code{\link{addFilter}}
}

