% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R, R/writessh.R
\name{write_pem}
\alias{write_der}
\alias{write_pem}
\alias{write_ssh}
\title{Export key or certificate}
\usage{
write_pem(x, path = NULL, password = readline)

write_der(x, path = NULL)

write_ssh(pubkey, path = NULL)
}
\arguments{
\item{x}{a public/private key or certificate object}

\item{path}{file to write to. If \code{NULL} it returns the output as a string.}

\item{password}{string or callback function to set password (only applicable for
private keys).}

\item{pubkey}{a public key}
}
\description{
The \code{write_pem} functions exports a key or certificate to the standard
base64 PEM format. For private keys it is possible to set a password.
}
\examples{
# Generate RSA keypair
key <- rsa_keygen()
pubkey <- as.list(key)$pubkey

# Write to output formats
write_ssh(pubkey)
write_pem(pubkey)
write_pem(key, password = "super secret")
}

