% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsong.R
\name{subsong}
\alias{subsong}
\alias{subsong<-}
\title{Get or set the current subsong in an \code{openmpt} module}
\usage{
subsong(mod, ...)

subsong(mod, ...) <- value
}
\arguments{
\item{mod}{A tracker module object of class \code{openmpt}.}

\item{...}{Ignored}

\item{value}{An \code{integer} index of the subsong to select.}
}
\value{
Returns the \code{integer} index of the currently selected subsong.
In case of the assign operator (\verb{<-}) it returns a version of
\code{mod} with an update selection for the subsong
}
\description{
Some \code{openmpt} modules may contain multiple subsongs. Use these
functions to get the current subsong index, or select a different one.
}
\examples{
mod <- demo_mod()
subsong(mod)
## a value of -1 plays all subsongs consecutively
subsong(mod) <- -1
}
