% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqMap.R
\name{freqMap}
\alias{freqMap}
\title{Polar frequency plots on interactive leaflet maps}
\usage{
freqMap(
  data,
  pollutant = "nox",
  statistic = "mean",
  latitude = "lat",
  longitude = "lon",
  provider = "OpenStreetMap",
  type = "default",
  cols = "jet",
  alpha = 1,
  key = FALSE,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 4,
  fig.height = 4,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot a
\code{\link[openair:polarFreq]{openair::polarFreq()}}, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they can be toggled between using a "layer
control" interface.}

\item{statistic}{The statistic that should be applied to each wind
speed/direction bin. Can be \dQuote{frequency}, \dQuote{mean},
\dQuote{median}, \dQuote{max} (maximum), \dQuote{stdev} (standard
deviation) or \dQuote{weighted.mean}. The option \dQuote{frequency} (the
default) is the simplest and plots the frequency of wind speed/direction in
different bins. The scale therefore shows the counts in each bin. The
option \dQuote{mean} will plot the mean concentration of a pollutant (see
next point) in wind speed/direction bins, and so on.  Finally,
\dQuote{weighted.mean} will plot the concentration of a pollutant weighted
by wind speed/direction. Each segment therefore provides the percentage
overall contribution to the total concentration. Note that for options
other than \dQuote{frequency}, it is necessary to also provide the name of
a pollutant. See function \code{\link[openair:cutData]{openair::cutData()}} for further details.}

\item{latitude}{The decimal latitude.}

\item{longitude}{The decimal longitude.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{type}{The grouping variable that provides a data set for a specific
location. Often, with several sites, \code{type = "site"} is used.}

\item{cols}{The colours used for plotting.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should the key of the plot be drawn. Default is \code{FALSE}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{...}{Other arguments for \code{\link[openair:polarFreq]{openair::polarFreq()}}.}
}
\value{
A leaflet object.
}
\description{
Polar frequency plots on interactive leaflet maps
}
\examples{
\dontrun{
freqMap(polar_data,
  statistic = "mean",
  type = "site",
  provider = "Stamen.Toner"
)
}
}
