% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importWAQN.R
\name{importWAQN}
\alias{importWAQN}
\title{Import data from the Welsh Air Quality Network}
\usage{
importWAQN(
  site = "card",
  year = 2018,
  data_type = "hourly",
  pollutant = "all",
  meta = FALSE,
  meteo = TRUE,
  ratified = FALSE,
  to_narrow = FALSE,
  progress = TRUE
)
}
\arguments{
\item{site}{Site code of the site to import e.g. \dQuote{card} is Cardiff
Centre. Several sites can be imported with \code{site = c("card", "car04")}
--- to import Cardiff Centre and Castle Street, for example.}

\item{year}{Year or years to import. To import a sequence of years from 1990
to 2000 use \code{year = 1990:2000}. To import several specific years use
\code{year = c(1990, 1995, 2000)} for example.}

\item{data_type}{The data type averaging period. These include:

\itemize{
\item{"hourly"}{ Default is to return hourly data.}
\item{"daily"}{ Daily average data.}
\item{"monthly"}{ Monthly average
data with data capture information for the whole network.}
\item{"annual"}{ Annual average data with data capture information for the
whole network.}
\item{"15_min"}{ To import 15-minute average SO2
concentrations.}
\item{"8_hour"}{ To import 8-hour rolling mean
concentrations for O3 and CO.}
\item{"24_hour"}{ To import 24-hour rolling
mean concentrations for particulates.}
\item{"daily_max_8"}{ To import maximum daily rolling 8-hour maximum for O3 and CO.}
\item{"daqi"}{ To import Daily
Air Quality Index (DAQI). See
\href{https://uk-air.defra.gov.uk/air-pollution/daqi?view=more-info&pollutant=ozone#pollutant}{here}
for more details of how the index is defined.} }}

\item{pollutant}{Pollutants to import. If omitted will import all pollutants
from a site. To import only NOx and NO2 for example use \code{pollutant =
  c("nox", "no2")}.}

\item{meta}{Should meta data be returned? If \code{TRUE} the site type,
latitude and longitude are returned.}

\item{meteo}{Should modelled meteorological data be returned if available.
The default is \code{TRUE} and will return wind speed (\code{ws}), wind
direction (\code{wd}) and ambient temperature (\code{air_temp}). The
variables are calculated from using the WRF model run by Ricardo Energy &
Environment and are available for most but not all networks. Setting
\code{meteo = FALSE} is useful if you have other meteorological data to use
in preference e.g. from \code{\link[worldmet]{worldmet}}.}

\item{ratified}{If \code{TRUE} columns are returned indicating when each
species was ratified i.e. quality-checked. Available for hourly data only.}

\item{to_narrow}{By default the returned data has a column for each
pollutant/variable. When \code{to_narrow = TRUE} the data are stacked into
a narrow format with a column identifying the pollutant name.}

\item{progress}{Show a progress bar when many sites/years are being imported?
Defaults to \code{TRUE}.}
}
\description{
Import data from the Welsh Air Quality Network
}
\seealso{
Other import functions: 
\code{\link{importADMS}()},
\code{\link{importAQE}()},
\code{\link{importAURN}()},
\code{\link{importEurope}()},
\code{\link{importKCL}()},
\code{\link{importLocal}()},
\code{\link{importMeta}()},
\code{\link{importNI}()},
\code{\link{importSAQN}()},
\code{\link{importTraj}()}
}
\concept{import functions}
