% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_embedding.R
\name{create_embedding}
\alias{create_embedding}
\title{Create embeddings}
\usage{
create_embedding(
  engine_id = deprecated(),
  model,
  input,
  user = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{engine_id}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{model}{required; a length one character vector.}

\item{input}{required; an arbitrary length character vector.}

\item{user}{optional; defaults to \code{NULL}; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, an element of which contains embedding vector(s) for
a given input.
}
\description{
Creates an embedding vector that represents the provided input. See \href{https://platform.openai.com/docs/api-reference/embeddings/create}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/embeddings/create}{official documentation}.
}
\examples{
\dontrun{
create_embedding(
    model = "text-similarity-babbage-001",
    input = c(
        "Ah, it is so boring to write documentation",
        "But examples are really crucial"
    )
)
}
}
