% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_files.R
\name{list_files}
\alias{list_files}
\title{List files}
\usage{
list_files(
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, an element of which is a data frame containing
information about files.
}
\description{
Lists files uploaded by user's organization. See \href{https://beta.openai.com/docs/api-reference/files/list}{this page} for details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/files/list}{official documentation}.
}
\examples{
\dontrun{
list_files()
}
}
\seealso{
Other file functions: 
\code{\link{delete_file}()},
\code{\link{retrieve_file_content}()},
\code{\link{retrieve_file}()},
\code{\link{upload_file}()}
}
\concept{file functions}
