/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.maxent.io.GISModelReader;
import opennlp.maxent.io.PlainTextGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class SuffixSensitiveGISModelReader
extends GISModelReader {
    private final GISModelReader suffixAppropriateReader;

    public SuffixSensitiveGISModelReader(File f) throws IOException {
        BufferedInputStream input;
        String filename = f.getName();
        if (filename.endsWith(".gz")) {
            input = new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
            filename = filename.substring(0, filename.length() - 3);
        } else {
            input = new BufferedInputStream(new FileInputStream(f));
        }
        this.suffixAppropriateReader = filename.endsWith(".bin") ? new BinaryGISModelReader(new DataInputStream(input)) : new PlainTextGISModelReader(new BufferedReader(new InputStreamReader(input)));
    }

    protected int readInt() throws IOException {
        return this.suffixAppropriateReader.readInt();
    }

    protected double readDouble() throws IOException {
        return this.suffixAppropriateReader.readDouble();
    }

    protected String readUTF() throws IOException {
        return this.suffixAppropriateReader.readUTF();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 2) {
            GISModel m = new SuffixSensitiveGISModelReader(new File(args[0])).getModel();
            new SuffixSensitiveGISModelWriter(m, new File(args[1])).persist();
        } else {
            System.err.println("Usage: SuffixSensitiveGISModelReader model1 mode2");
            System.err.println("Load model1 and converts it into the model file format specified by the model2 name.");
        }
    }
}

