/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import opennlp.maxent.Context;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.TIntParamHashMap;
import opennlp.maxent.TObjectIndexHashMap;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

public final class GISModel
implements MaxentModel {
    private final Context[] params;
    private final TObjectIndexHashMap pmap;
    private final String[] ocNames;
    private final double correctionConstant;
    private final double correctionParam;
    private final int numOutcomes;
    private final double iprob;
    private final double fval;
    private DecimalFormat df;
    private int[] numfeats;

    public GISModel(Context[] _params, String[] predLabels, String[] _ocNames, int _correctionConstant, double _correctionParam) {
        this.pmap = new TObjectIndexHashMap(predLabels.length);
        int i = 0;
        while (i < predLabels.length) {
            this.pmap.put(predLabels[i], i);
            ++i;
        }
        this.params = _params;
        this.ocNames = _ocNames;
        this.correctionConstant = _correctionConstant;
        this.correctionParam = _correctionParam;
        this.numOutcomes = this.ocNames.length;
        this.iprob = Math.log(1.0 / (double)this.numOutcomes);
        this.fval = 1.0 / this.correctionConstant;
        this.numfeats = new int[this.numOutcomes];
    }

    private static Context[] convertToContexts(TIntParamHashMap[] params) {
        Context[] contexts = new Context[params.length];
        int pi = 0;
        while (pi < params.length) {
            int[] activeOutcomes = params[pi].keys();
            double[] activeParameters = new double[activeOutcomes.length];
            int oi = 0;
            while (oi < activeParameters.length) {
                activeParameters[oi] = params[pi].get(activeOutcomes[oi]);
                ++oi;
            }
            contexts[pi] = new Context(activeOutcomes, activeParameters);
            ++pi;
        }
        return contexts;
    }

    public final double[] eval(String[] context) {
        return this.eval(context, new double[this.numOutcomes]);
    }

    public final double[] eval(String[] context, double[] outsums) {
        int oid = 0;
        while (oid < this.numOutcomes) {
            outsums[oid] = this.iprob;
            this.numfeats[oid] = 0;
            ++oid;
        }
        int i = 0;
        while (i < context.length) {
            int contextIndex = this.pmap.get(context[i]);
            if (contextIndex >= 0) {
                Context predParams = this.params[contextIndex];
                int[] activeOutcomes = predParams.getOutcomes();
                double[] activeParameters = predParams.getParameters();
                int j = 0;
                while (j < activeOutcomes.length) {
                    int oid2;
                    int n = oid2 = activeOutcomes[j];
                    this.numfeats[n] = this.numfeats[n] + 1;
                    int n2 = oid2;
                    outsums[n2] = outsums[n2] + activeParameters[j];
                    ++j;
                }
            }
            ++i;
        }
        double normal = 0.0;
        int oid3 = 0;
        while (oid3 < this.numOutcomes) {
            outsums[oid3] = Math.exp(outsums[oid3] * this.fval + (1.0 - (double)this.numfeats[oid3] / this.correctionConstant) * this.correctionParam);
            normal += outsums[oid3];
            ++oid3;
        }
        oid3 = 0;
        while (oid3 < this.numOutcomes) {
            int n = oid3++;
            outsums[n] = outsums[n] / normal;
        }
        return outsums;
    }

    public final String getBestOutcome(double[] ocs) {
        int best = 0;
        int i = 1;
        while (i < ocs.length) {
            if (ocs[i] > ocs[best]) {
                best = i;
            }
            ++i;
        }
        return this.ocNames[best];
    }

    public final String getAllOutcomes(double[] ocs) {
        if (ocs.length != this.ocNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        if (this.df == null) {
            this.df = new DecimalFormat("0.0000");
        }
        StringBuffer sb = new StringBuffer(ocs.length * 2);
        sb.append(this.ocNames[0]).append("[").append(this.df.format(ocs[0])).append("]");
        int i = 1;
        while (i < ocs.length) {
            sb.append("  ").append(this.ocNames[i]).append("[").append(this.df.format(ocs[i])).append("]");
            ++i;
        }
        return sb.toString();
    }

    public final String getOutcome(int i) {
        return this.ocNames[i];
    }

    public int getIndex(String outcome) {
        int i = 0;
        while (i < this.ocNames.length) {
            if (this.ocNames[i].equals(outcome)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getNumOutcomes() {
        return this.numOutcomes;
    }

    public final Object[] getDataStructures() {
        Object[] data = new Object[]{this.params, this.pmap, this.ocNames, new Integer((int)this.correctionConstant), new Double(this.correctionParam)};
        return data;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: GISModel modelname < contexts");
            System.exit(1);
        }
        GISModel m = new SuffixSensitiveGISModelReader(new File(args[0])).getModel();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        DecimalFormat df = new DecimalFormat(".###");
        String line = in.readLine();
        while (line != null) {
            String[] context = line.split(" ");
            double[] dist = m.eval(context);
            int oi = 0;
            while (oi < dist.length) {
                System.out.print("[" + m.getOutcome(oi) + " " + df.format(dist[oi]) + "] ");
                ++oi;
            }
            System.out.println();
            line = in.readLine();
        }
    }
}

