% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_posteriorCalcs.R
\name{ebgm}
\alias{ebgm}
\title{Calculate EBGM scores}
\usage{
ebgm(theta_hat, N, E, qn, digits = 2)
}
\arguments{
\item{theta_hat}{A numeric vector of hyperparameter estimates (likely from
\code{\link{autoHyper}} or from directly minimizing
\code{\link{negLLsquash}}) ordered as:
\eqn{\alpha_1, \beta_1, \alpha_2, \beta_2, P}.}

\item{N}{A whole number vector of actual counts from
\code{\link{processRaw}}.}

\item{E}{A numeric vector of expected counts from \code{\link{processRaw}}.}

\item{qn}{A numeric vector of posterior probabilities that \eqn{\lambda} came
from the first component of the mixture, given \emph{N = n} (i.e., the
mixture fraction). See function \code{\link{Qn}}.}

\item{digits}{A scalar whole number that determines the number of decimal
places used when rounding the results.}
}
\value{
A numeric vector of EBGM scores.
}
\description{
\code{ebgm} calculates the Empirical Bayes Geometric Mean (\emph{EBGM}),
which is \sQuote{the geometric mean of the empirical Bayes posterior
distribution of the \dQuote{true} \emph{RR}} (DuMouchel 1999, see Eq.11). The
\emph{EBGM} is essentially a version of the relative reporting ratio
(\emph{RR}) that uses Bayesian shrinkage.
}
\details{
The hyperparameter estimates (\code{theta_hat}) are:
  \itemize{
    \item{\eqn{\alpha_1, \beta_1}: }{Parameter estimates of the first
      component of the prior distribution}
    \item{\eqn{\alpha_2, \beta_2}: }{Parameter estimates of the second
      component}
    \item{\eqn{P}: }{Mixture fraction estimate of the prior distribution}
}
}
\examples{
theta_init <- data.frame(
  alpha1 = c(0.2, 0.1),
  beta1  = c(0.1, 0.1),
  alpha2 = c(2,   10),
  beta2  = c(4,   10),
  p      = c(1/3, 0.2)
)
data(caers)
proc <- processRaw(caers)
squashed <- squashData(proc, bin_size = 100, keep_pts = 100)
squashed <- squashData(squashed, count = 2, bin_size = 10, keep_pts = 20)
suppressWarnings(
  theta_hat <- autoHyper(data = squashed, theta_init = theta_init)$estimates
)
qn <- Qn(theta_hat, N = proc$N, E = proc$E)
proc$EBGM <- ebgm(theta_hat, N = proc$N, E = proc$E, qn = qn)
head(proc)

}
\references{
DuMouchel W (1999). "Bayesian Data Mining in Large Frequency
  Tables, With an Application to the FDA Spontaneous Reporting System."
  \emph{The American Statistician}, 53(3), 177-190.
}
\seealso{
\code{\link{autoHyper}},  \code{\link{exploreHypers}},
  \code{\link{negLLsquash}}, \code{\link{negLL}},
  \code{\link{negLLzero}}, and \code{\link{negLLzeroSquash}} for
  hyperparameter estimation.

\code{\link{processRaw}} for finding counts.

\code{\link{Qn}} for finding mixture fractions.

Other posterior distribution functions: \code{\link{Qn}},
  \code{\link{quantBisect}}
}
\keyword{openEBGM}
