% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.profile_perm}
\alias{dsadmin.profile_perm}
\title{Get the permissions of a DataSHIELD profile}
\usage{
dsadmin.profile_perm(opal, name)
}
\arguments{
\item{opal}{Opal connection object.}

\item{name}{Profile name.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions of a DataSHIELD profile
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.profile_perm_add(o, 'default', c('andrei', 'valentina'), 'user', 'use')
dsadmin.profile_perm(o, 'default')
dsadmin.profile_perm_delete(o, 'default', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD profiles: 
\code{\link{dsadmin.profile}()},
\code{\link{dsadmin.profile_access}()},
\code{\link{dsadmin.profile_create}()},
\code{\link{dsadmin.profile_delete}()},
\code{\link{dsadmin.profile_enable}()},
\code{\link{dsadmin.profile_exists}()},
\code{\link{dsadmin.profile_init}()},
\code{\link{dsadmin.profile_perm_add}()},
\code{\link{dsadmin.profile_perm_delete}()},
\code{\link{dsadmin.profile_rparser}()},
\code{\link{dsadmin.profiles}()}
}
\concept{DataSHIELD profiles}
