% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.project.R
\name{opal.project_exists}
\alias{opal.project_exists}
\title{Check a project exists}
\usage{
opal.project_exists(opal, project)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project}
}
\value{
A logical
}
\description{
Check whether a project already exists (and is visible by the requesting user).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.project_exists(o, 'test')
opal.logout(o)
}
}
\seealso{
Other project functions: 
\code{\link{opal.project_create}()},
\code{\link{opal.project_delete}()},
\code{\link{opal.projects}()},
\code{\link{opal.project}()},
\code{\link{opal.resource_create}()},
\code{\link{opal.resource_exists}()},
\code{\link{opal.resource_extension_create}()},
\code{\link{opal.resource_get}()},
\code{\link{opal.resources}()},
\code{\link{opal.resource}()}
}
\concept{project functions}
