% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.install_package}
\alias{dsadmin.install_package}
\title{Install a DataSHIELD package}
\usage{
dsadmin.install_package(opal, pkg, githubusername = NULL, ref = NULL)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{pkg}{Package name.}

\item{githubusername}{GitHub username of git repository. If NULL (default), try to install from DataSHIELD package repository.}

\item{ref}{Desired git reference (could be a commit, tag, or branch name). If NULL (default), try to install from DataSHIELD package repository.}
}
\value{
TRUE if installed
}
\description{
Install a package from DataSHIELD public package repository or (if Git reference and GitHub username is provided) from DataSHIELD source repository on GitHub.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.install_package(o, 'dsBase')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: 
\code{\link{dsadmin.get_methods}()},
\code{\link{dsadmin.get_method}()},
\code{\link{dsadmin.get_options}()},
\code{\link{dsadmin.install_github_package}()},
\code{\link{dsadmin.install_local_package}()},
\code{\link{dsadmin.installed_package}()},
\code{\link{dsadmin.package_descriptions}()},
\code{\link{dsadmin.package_description}()},
\code{\link{dsadmin.remove_package}()},
\code{\link{dsadmin.rm_methods}()},
\code{\link{dsadmin.rm_method}()},
\code{\link{dsadmin.rm_option}()},
\code{\link{dsadmin.rm_package_methods}()},
\code{\link{dsadmin.set_method}()},
\code{\link{dsadmin.set_option}()},
\code{\link{dsadmin.set_package_methods}()}
}
\concept{DataSHIELD functions}
