% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.execute.r
\name{opal.execute.source}
\alias{opal.execute.source}
\title{Execute a R file script}
\usage{
opal.execute.source(opal, path, async = FALSE)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{path}{Path to the R file script to execute.}

\item{async}{R script is executed asynchronously within the session (default is FALSE). 
If TRUE, the value returned is the ID of the command to look for (from Opal 2.1).}
}
\description{
Upload a R file script and execute it in the remote R session with source().
}
\examples{
\dontrun{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
opal.execute.source(o, "myscript.R")
opal.logout(o)
}
}
\seealso{
Other execution functions: 
\code{\link{opal.execute}()},
\code{\link{opal.load_package}()},
\code{\link{opal.unload_package}()}
}
\concept{execution functions}
