% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.annotations.r
\name{opal.annotate}
\alias{opal.annotate}
\title{Apply the annotations to a Opal table}
\usage{
opal.annotate(opal, datasource, table, annotations)
}
\arguments{
\item{opal}{Opal object.}

\item{datasource}{Name of the datasource.}

\item{table}{Name of the table in the datasource.}

\item{annotations}{A data frame of annotations, with the expected columns: 'variable' (variable name),
'taxonomy' (the taxonomy name), 'vocabulary' (the vocabulary name) and 'term' (the term value, if NULL
of NA the annotation is removed).}
}
\description{
Set the provided annotations (as the one that can be retrieved from \link{opal.annotations})
to the table's data dictionary. Variables that do not exists in the table are ignored.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
annots <- opal.annotations(o, 'CPTP', 'Coreqx_final')
opal.annotate(o, 'CPTP', 'Cag_coreqx', annots)
opal.logout(o)
}
}
\seealso{
Other datasource functions: \code{\link{opal.annotations}},
  \code{\link{opal.attribute_values}},
  \code{\link{opal.datasources}},
  \code{\link{opal.datasource}},
  \code{\link{opal.projects}}, \code{\link{opal.project}},
  \code{\link{opal.tables}}, \code{\link{opal.table}},
  \code{\link{opal.valueset}},
  \code{\link{opal.variables}}, \code{\link{opal.variable}}
}
\concept{datasource functions}
