% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_md_def.R
\name{fetch_md_def}
\alias{fetch_md_def}
\title{Fetch Markdown Default Format from onbrand Object}
\usage{
fetch_md_def(obnd, style = "default", verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{style}{name of style in md_def for the report type in obnd to fetch (\code{"default"})}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned onbrand
object.}
}
\value{
list with the following elements
\itemize{
\item{isgood}: Boolean variable indicating success or failure
\item{md_def}: List with the default format for the specified style
\item{msgs}: Vector of messages
}
}
\description{
Used to extract the formatting elements for a given style from
an onbrand object.
}
\examples{
obnd = read_template(
   template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
   mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))
obnd = fetch_md_def(obnd, style="default")
md_def =  obnd[["md_def"]]
}
