context("stepAIC backward regression output")

model <- lm(y ~ ., data = surgical)

test_that("output from stepAIC backward regression is as expected", {
  x <- cat("

                       Backward Elimination Summary
-------------------------------------------------------------------------
Variable        AIC          RSS          Sum Sq       R-Sq     Adj. R-Sq
-------------------------------------------------------------------------
Full Model    736.390    1825905.713    6543614.824    0.782        0.743
alc_mod       734.407    1826477.828    6543042.709    0.782        0.749
gender        732.494    1829435.617    6540084.920    0.781        0.754
age           730.620    1833716.447    6535804.090    0.781        0.758
-------------------------------------------------------------------------")


  expect_output(print(ols_step_backward_aic(model)), x)
})


test_that("output from stepAIC backward regression is as expected when details == TRUE", {
  x <- cat(" Step 0: AIC = 736.3899
 y ~ bcs + pindex + enzyme_test + liver_test + age + gender + alc_mod + alc_heavy

--------------------------------------------------------------------------------
Variable       DF      AIC        Sum Sq           RSS        R-Sq     Adj. R-Sq
--------------------------------------------------------------------------------
alc_mod        1     734.407        572.115    1826477.828    0.782        0.749
gender         1     734.478       2990.338    1828896.051    0.781        0.748
age            1     734.544       5231.108    1831136.821    0.781        0.748
liver_test     1     735.878      51016.156    1876921.869    0.776        0.742
bcs            1     741.677     263780.393    2089686.106    0.750        0.712
alc_heavy      1     749.210     576636.222    2402541.935    0.713        0.669
pindex         1     756.624     930187.311    2756093.024    0.671        0.621
enzyme_test    1     763.557    1307756.930    3133662.644    0.626        0.569
--------------------------------------------------------------------------------

 Step 1 : AIC = 734.4068
 y ~ bcs + pindex + enzyme_test + liver_test + age + gender + alc_heavy

--------------------------------------------------------------------------------
Variable       DF      AIC        Sum Sq           RSS        R-Sq     Adj. R-Sq
--------------------------------------------------------------------------------
gender         1     732.494       2957.789    1829435.617    0.781        0.754
age            1     732.551       4878.331    1831356.159    0.781        0.753
liver_test     1     733.921      51951.343    1878429.171    0.776        0.747
bcs            1     739.677     263219.094    2089696.922    0.750        0.718
alc_heavy      1     750.486     726328.685    2552806.513    0.695        0.656
pindex         1     754.759     936543.762    2763021.590    0.670        0.628
enzyme_test    1     761.595    1309433.007    3135910.834    0.625        0.577
--------------------------------------------------------------------------------

 Step 2 : AIC = 732.4942
 y ~ bcs + pindex + enzyme_test + liver_test + age + alc_heavy

--------------------------------------------------------------------------------
Variable       DF      AIC        Sum Sq           RSS        R-Sq     Adj. R-Sq
--------------------------------------------------------------------------------
age            1     730.620       4280.830    1833716.447    0.781        0.758
liver_test     1     732.339      63596.190    1893031.807    0.774        0.750
bcs            1     737.680     260398.979    2089834.596    0.750        0.724
alc_heavy      1     748.486     723371.473    2552807.090    0.695        0.663
pindex         1     752.777     934511.071    2763946.688    0.670        0.635
enzyme_test    1     759.596    1306482.666    3135918.283    0.625        0.586
--------------------------------------------------------------------------------

 Step 3 : AIC = 730.6204
 y ~ bcs + pindex + enzyme_test + liver_test + alc_heavy

--------------------------------------------------------------------------------
Variable       DF      AIC        Sum Sq           RSS        R-Sq     Adj. R-Sq
--------------------------------------------------------------------------------
liver_test     1     730.924      79919.825    1913636.272    0.771        0.753
bcs            1     735.715     257444.030    2091160.477    0.750        0.730
alc_heavy      1     747.181     752122.827    2585839.274    0.691        0.666
pindex         1     750.782     930453.646    2764170.093    0.670        0.643
enzyme_test    1     757.971    1324076.125    3157792.572    0.623        0.592
--------------------------------------------------------------------------------

No more variables to be removed.


                       Backward Elimination Summary
-------------------------------------------------------------------------
Variable        AIC          RSS          Sum Sq       R-Sq     Adj. R-Sq
-------------------------------------------------------------------------
Full Model    736.390    1825905.713    6543614.824    0.782        0.743
alc_mod       734.407    1826477.828    6543042.709    0.782        0.749
gender        732.494    1829435.617    6540084.920    0.781        0.754
age           730.620    1833716.447    6535804.090    0.781        0.758
-------------------------------------------------------------------------")


  expect_output(print(ols_step_backward_aic(model, details = TRUE)), x)
})
