% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-cooks-d-chart.R
\name{ols_plot_cooksd_chart}
\alias{ols_plot_cooksd_chart}
\alias{ols_cooksd_chart}
\title{Cooks' D chart}
\usage{
ols_plot_cooksd_chart(model)
}
\arguments{
\item{model}{An object of class \code{lm}.}
}
\value{
\code{ols_plot_cooksd_chart} returns  a list containing the
following components:

\item{outliers}{a tibble with observation number and \code{cooks distance} that exceed \code{threshold}}
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Chart of cook's distance to detect observations that strongly influence
fitted values of the model.
}
\details{
Cook's distance was introduced by American statistician R Dennis Cook in
1977. It is used to identify influential data points. It depends on both the
residual and leverage i.e it takes it account both the \emph{x} value and
\emph{y} value of the observation.

Steps to compute Cook's distance:

\itemize{
  \item Delete observations one at a time.
  \item Refit the regression model on remaining \eqn{n - 1} observations
  \item exmine how much all of the fitted values change when the ith observation is deleted.
}

A data point having a large cook's d indicates that the data point strongly influences the fitted values.
}
\section{Deprecated Function}{

\code{ols_cooksd_chart()} has been deprecated. Instead use \code{ols_plot_cooksd_chart()}.
}

\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_cooksd_chart(model)

}
\seealso{
[ols_plot_cooksd_bar()]
}
