context("plots")

test_that("ovsp_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_obs_fit(m), "Please specify a OLS linear regression model.")
})

test_that("rvsr_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_regressor(m), "Please specify a OLS linear regression model.")
})


test_that("rvsp_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_fit(m), "Please specify a OLS linear regression model.")
})

test_that("qqresid fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_qq(m), "Please specify a OLS linear regression model.")
})

test_that("residual histogram fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_hist(m), "Please specify a OLS linear regression model.")
})

test_that("diag_panel fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_diagnostics(m), "Please specify a OLS linear regression model.")
})

test_that("rfs_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_fit_spread(m), "Please specify a OLS linear regression model.")
})

test_that("fm_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_fm(m), "Please specify a OLS linear regression model.")
})

test_that("rsd_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_spread(m), "Please specify a OLS linear regression model.")
})

test_that("hadi_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_hadi(m), "Please specify a OLS linear regression model.")
})

test_that("poten_resid_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_pot(m), "Please specify a OLS linear regression model.")
})

test_that("added variable plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_added_variable(m), "Please specify a OLS linear regression model.")
})

test_that("cplusr_plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_comp_plus_resid(m), "Please specify a OLS linear regression model.")
})

test_that("residual boxplot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_box(m), "Please specify a OLS linear regression model.")
})

test_that("cooks d barplot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_cooksd_bar(m), "Please specify a OLS linear regression model.")
})

test_that("cooks d chart fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_cooksd_chart(m), "Please specify a OLS linear regression model.")
})

test_that("dfbetas panel fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_dfbetas(m), "Please specify a OLS linear regression model.")
})

test_that("dffits plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_dffits(m), "Please specify a OLS linear regression model.")
})

test_that("dsrvsp plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_stud_fit(m), "Please specify a OLS linear regression model.")
})

test_that("rsdlev plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_lev(m), "Please specify a OLS linear regression model.")
})

test_that("studentized residual plot fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_stud(m), "Please specify a OLS linear regression model.")
})

test_that("studentized residual chart fails when model inherits other than 'lm'", {
  y <- sample(c(1:4), 100, replace = T)
  x <- sample(c(1, 2), 100, replace = T)
  m <- glm(x ~ y)
  expect_error(ols_plot_resid_stand(m), "Please specify a OLS linear regression model.")
})
