% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-f-test.R
\name{ols_f_test}
\alias{ols_f_test}
\title{F Test for Constant Variance}
\usage{
ols_f_test(model, fitted_values = TRUE, rhs = FALSE, vars = NULL, ...)
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{fitted_values}{logical; if TRUE, use fitted values of regression model}

\item{rhs}{logical; if TRUE, specifies that tests for heteroskedasticity be
performed for the right-hand-side (explanatory) variables of the fitted
regression model}

\item{vars}{variables to be used for for heteroskedasticity test}

\item{...}{other arguments}
}
\value{
\code{ols_f_test} returns an object of class \code{"ols_f_test"}.
An object of class \code{"ols_f_test"} is a list containing the
following components:

\item{f}{f statistic}
\item{p}{p-value of \code{f}}
\item{fv}{fitted values of the regression model}
\item{rhs}{names of explanatory variables of fitted regression model}
\item{numdf}{numerator degrees of freedom}
\item{dendf}{denominator degrees of freedom}
\item{vars}{variables to be used for heteroskedasticity test}
\item{resp}{response variable}
\item{preds}{predictors}
}
\description{
Test for heteroskedasticity under the assumption that
the errors are independent and identically distributed (i.i.d.).
}
\examples{
# model
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)

# using fitted values
ols_f_test(model)

# using all predictors of the model
ols_f_test(model, rhs = TRUE)

# using fitted values
ols_f_test(model, vars = c('disp', 'hp'))
}
\references{
Wooldridge, J. M. 2013. Introductory Econometrics: A Modern Approach. 5th ed. Mason, OH: South-Western.
}
