% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_blocks}
\alias{body_add_blocks}
\title{add a list of blocks into a document}
\usage{
body_add_blocks(x, blocks, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{blocks}{set of blocks to be used as footnote content returned by
function \code{\link{block_list}}.}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
add a list of blocks produced by \code{block_list} into
into an rdocx object
}
\examples{
library(magrittr)

img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
bl <- block_list(
  fpar(ftext("hello", shortcuts$fp_bold())),
  fpar(
    ftext("hello world", shortcuts$fp_bold()),
    external_img(src = img.file, height = 1.06, width = 1.39)
  )
)

x <- read_docx() \%>\%
  body_add_blocks( blocks = bl ) \%>\%
  print(target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_break}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()}
}
\concept{functions for adding content}
